/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.message.util;

public class MessageBuilder {
    private StringBuilder builder;

    public MessageBuilder() {
        this.builder = new StringBuilder();
    }

    public MessageBuilder(int capacity) {
        this.builder = new StringBuilder(capacity);
    }

    public MessageBuilder(String str) {
        this.builder = new StringBuilder(str);
    }

    public void append(String str) {
        this.builder.append(str);
    }

    public void insert(String str) {
        this.builder.insert(0, str);
    }

    public void surroundWith(String tag) {
        StringBuilder sb = new StringBuilder(this.builder.capacity() + tag.length() * 2 + 5);
        sb.append("<").append(tag).append(">\n").append((CharSequence)this.builder).append("</").append(tag).append(">\n");
        this.builder = sb;
    }

    public void addTag(String tagName, String text) {
        if (text == null) {
            return;
        }
        this.builder.append("<").append(tagName).append(">").append(text).append("</").append(tagName).append(">\n");
    }

    public void addData(String tagName, String data) {
        if (data == null) {
            return;
        }
        this.builder.append("<").append(tagName).append("><![CDATA[").append(data).append("]]></").append(tagName).append(">\n");
    }

    public String toString() {
        return this.builder.toString();
    }
}

