/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.CollectionUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.common.util.ValidateUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.handler.JaxrsHeaderHandler;
import com.power.doc.handler.JaxrsPathHandler;
import com.power.doc.helper.FormDataBuildHelper;
import com.power.doc.helper.JsonBuildHelper;
import com.power.doc.helper.ParamsBuildHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiMethodReqParam;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.DocJavaMethod;
import com.power.doc.model.FormData;
import com.power.doc.model.request.ApiRequestExample;
import com.power.doc.model.request.CurlRequest;
import com.power.doc.model.request.JaxrsPathMapping;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.template.SpringBootDocBuildTemplate;
import com.power.doc.utils.ApiParamTreeUtil;
import com.power.doc.utils.CurlUtil;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocPathUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.JsonUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JaxrsDocBuildTemplate
implements IDocBuildTemplate<ApiDoc> {
    private static Logger log = Logger.getLogger(SpringBootDocBuildTemplate.class.getName());
    private final AtomicInteger atomicInteger = new AtomicInteger(1);
    private List<ApiReqParam> headers;

    @Override
    public List<ApiDoc> getApiData(ProjectDocConfigBuilder projectBuilder) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        this.headers = apiConfig.getRequestHeaders();
        ArrayList<ApiDoc> apiDocList = new ArrayList<ApiDoc>();
        int order = 0;
        Collection classes = projectBuilder.getJavaProjectBuilder().getClasses();
        boolean setCustomOrder = false;
        for (JavaClass cls : classes) {
            if (StringUtil.isNotEmpty((String)apiConfig.getPackageFilters()) && !DocUtil.isMatch(apiConfig.getPackageFilters(), cls.getCanonicalName())) continue;
            DocletTag ignoreTag = cls.getTagByName("ignore");
            if (!this.checkController(cls) || Objects.nonNull(ignoreTag)) continue;
            String strOrder = JavaClassUtil.getClassTagsValue(cls, "order", Boolean.TRUE);
            ++order;
            if (ValidateUtil.isNonnegativeInteger((String)strOrder)) {
                setCustomOrder = true;
                order = Integer.parseInt(strOrder);
            }
            List<ApiMethodDoc> apiMethodDocs = this.buildControllerMethod(cls, apiConfig, projectBuilder);
            this.handleApiDoc(cls, apiDocList, apiMethodDocs, order, apiConfig.isMd5EncryptedHtmlName());
        }
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
        } else if (setCustomOrder) {
            return apiDocList.stream().sorted(Comparator.comparing(ApiDoc::getOrder)).peek(p -> p.setOrder(this.atomicInteger.getAndAdd(1))).collect(Collectors.toList());
        }
        return apiDocList;
    }

    @Override
    public ApiDoc getSingleApiData(ProjectDocConfigBuilder projectBuilder, String apiClassName) {
        return null;
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return false;
    }

    private List<ApiMethodDoc> buildControllerMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder) {
        String clazName = cls.getCanonicalName();
        boolean paramsDataToTree = projectBuilder.getApiConfig().isParamsDataToTree();
        String group = JavaClassUtil.getClassTagsValue(cls, "group", Boolean.TRUE);
        String classAuthor = JavaClassUtil.getClassTagsValue(cls, "author", Boolean.TRUE);
        List<JavaAnnotation> classAnnotations = this.getAnnotations(cls);
        String baseUrl = "";
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getValue();
            if (!"Path".equals(annotationName) && !"javax.ws.rs.Path".equals(annotationName)) continue;
            baseUrl = StringUtil.removeQuotes((String)DocUtil.getRequestHeaderValue(annotation));
        }
        List methods = cls.getMethods();
        ArrayList<DocJavaMethod> docJavaMethods = new ArrayList<DocJavaMethod>(methods.size());
        for (JavaMethod method : methods) {
            if (method.isPrivate()) continue;
            docJavaMethods.add(DocJavaMethod.builder().setJavaMethod(method));
        }
        JavaClass parentClass = cls.getSuperJavaClass();
        if (Objects.nonNull(parentClass) && !"Object".equals(parentClass.getSimpleName())) {
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(parentClass);
            List parentMethodList = parentClass.getMethods();
            for (JavaMethod method : parentMethodList) {
                docJavaMethods.add(DocJavaMethod.builder().setJavaMethod(method).setActualTypesMap(actualTypesMap));
            }
        }
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        int methodOrder = 0;
        for (DocJavaMethod docJavaMethod : docJavaMethods) {
            DocletTag pageTag;
            JaxrsPathMapping jaxPathMapping;
            JavaMethod method = docJavaMethod.getJavaMethod();
            if (this.checkCondition(method) || Objects.isNull(jaxPathMapping = new JaxrsPathHandler().handle(projectBuilder, baseUrl, method))) continue;
            if (StringUtil.isEmpty((String)method.getComment()) && apiConfig.isStrict()) {
                throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
            }
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            DocletTag downloadTag = method.getTagByName("download");
            if (Objects.nonNull(downloadTag)) {
                apiMethodDoc.setDownload(true);
            }
            if (Objects.nonNull(pageTag = method.getTagByName("page"))) {
                String pageUrl = projectBuilder.getServerUrl() + "/" + pageTag.getValue();
                apiMethodDoc.setPage(UrlUtil.simplifyUrl((String)pageUrl));
            }
            DocletTag docletTag = method.getTagByName("group");
            apiMethodDoc.setGroup(group);
            if (Objects.nonNull(docletTag)) {
                apiMethodDoc.setGroup(docletTag.getValue());
            }
            apiMethodDoc.setName(method.getName());
            apiMethodDoc.setOrder(++methodOrder);
            String comment = DocUtil.getEscapeAndCleanComment(method.getComment());
            apiMethodDoc.setDesc(comment);
            String methodUid = DocUtil.generateId(clazName + method.getName());
            apiMethodDoc.setMethodId(methodUid);
            String apiNoteValue = DocUtil.getNormalTagComments(method, "apiNote", cls.getName());
            if (StringUtil.isEmpty((String)apiNoteValue)) {
                apiNoteValue = method.getComment();
            }
            Map<String, String> authorMap = DocUtil.getParamsComments(method, "author", cls.getName());
            String authorValue = String.join((CharSequence)", ", new ArrayList<String>(authorMap.keySet()));
            if (apiConfig.isShowAuthor() && StringUtil.isNotEmpty((String)authorValue)) {
                apiMethodDoc.setAuthor(JsonUtil.toPrettyFormat(authorValue));
            }
            if (apiConfig.isShowAuthor() && StringUtil.isEmpty((String)authorValue)) {
                apiMethodDoc.setAuthor(classAuthor);
            }
            apiMethodDoc.setDetail(apiNoteValue);
            List<ApiReqParam> ApiReqParams = new JaxrsHeaderHandler().handle(method, projectBuilder);
            apiMethodDoc.setType(jaxPathMapping.getMethodType());
            apiMethodDoc.setUrl(jaxPathMapping.getUrl());
            apiMethodDoc.setServerUrl(projectBuilder.getServerUrl());
            apiMethodDoc.setPath(jaxPathMapping.getShortUrl());
            apiMethodDoc.setDeprecated(jaxPathMapping.isDeprecated());
            List javaParameters = method.getParameters();
            JaxrsDocBuildTemplate.setTornaArrayTags(javaParameters, apiMethodDoc, docJavaMethod.getJavaMethod().getReturns());
            ApiMethodReqParam apiMethodReqParam = this.requestParams(docJavaMethod, projectBuilder);
            if (paramsDataToTree) {
                apiMethodDoc.setPathParams(ApiParamTreeUtil.apiParamToTree(apiMethodReqParam.getPathParams()));
                apiMethodDoc.setQueryParams(ApiParamTreeUtil.apiParamToTree(apiMethodReqParam.getQueryParams()));
                apiMethodDoc.setRequestParams(ApiParamTreeUtil.apiParamToTree(apiMethodReqParam.getRequestParams()));
            } else {
                apiMethodDoc.setPathParams(apiMethodReqParam.getPathParams());
                apiMethodDoc.setQueryParams(apiMethodReqParam.getQueryParams());
                apiMethodDoc.setRequestParams(apiMethodReqParam.getRequestParams());
            }
            List<ApiReqParam> allApiReqParams = ApiReqParams;
            if (this.headers != null) {
                allApiReqParams = Stream.of(this.headers, ApiReqParams).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            }
            allApiReqParams.removeIf(ApiReqParam2 -> {
                if (StringUtil.isEmpty((String)ApiReqParam2.getPathPatterns()) && StringUtil.isEmpty((String)ApiReqParam2.getExcludePathPatterns())) {
                    return false;
                }
                boolean flag = DocPathUtil.matches(jaxPathMapping.getShortUrl(), ApiReqParam2.getPathPatterns(), ApiReqParam2.getExcludePathPatterns());
                return !flag;
            });
            apiMethodDoc.setHeaders(this.createDocRenderHeaders(allApiReqParams, apiConfig.isAdoc()));
            apiMethodDoc.setRequestHeaders(allApiReqParams);
            ApiRequestExample requestExample = this.buildReqJson(docJavaMethod, apiMethodDoc, jaxPathMapping.getMethodType(), projectBuilder);
            String requestJson = requestExample.getExampleBody();
            apiMethodDoc.setRequestExample(requestExample);
            apiMethodDoc.setRequestUsage(requestJson == null ? requestExample.getUrl() : requestJson);
            String responseValue = DocUtil.getNormalTagComments(method, "response", cls.getName());
            if (StringUtil.isNotEmpty((String)responseValue)) {
                apiMethodDoc.setResponseUsage(responseValue);
            } else {
                apiMethodDoc.setResponseUsage(JsonBuildHelper.buildReturnJson(docJavaMethod, projectBuilder));
            }
            if (Objects.isNull(docletTag)) {
                apiMethodDoc.setDownload(docJavaMethod.isDownload());
            }
            List<ApiParam> responseParams = this.buildReturnApiParams(docJavaMethod, projectBuilder);
            if (paramsDataToTree) {
                responseParams = ApiParamTreeUtil.apiParamToTree(responseParams);
            }
            apiMethodDoc.setReturnSchema(docJavaMethod.getReturnSchema());
            apiMethodDoc.setRequestSchema(docJavaMethod.getRequestSchema());
            apiMethodDoc.setResponseParams(responseParams);
            methodDocList.add(apiMethodDoc);
        }
        return methodDocList;
    }

    private boolean checkCondition(JavaMethod method) {
        return method.isPrivate() || Objects.nonNull(method.getTagByName("ignore"));
    }

    private List<JavaAnnotation> getAnnotations(JavaClass cls) {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>(cls.getAnnotations());
        boolean flag = annotationsList.stream().anyMatch(item -> {
            String annotationName = item.getType().getValue();
            return "Path".equals(annotationName) || "javax.ws.rs.Path".equals(annotationName);
        });
        if (flag) {
            return annotationsList;
        }
        JavaClass superJavaClass = cls.getSuperJavaClass();
        if (Objects.nonNull(superJavaClass) && !"Object".equals(superJavaClass.getSimpleName())) {
            annotationsList.addAll(this.getAnnotations(superJavaClass));
        }
        return annotationsList;
    }

    private ApiMethodReqParam requestParams(DocJavaMethod docJavaMethod, ProjectDocConfigBuilder builder) {
        JavaMethod javaMethod = docJavaMethod.getJavaMethod();
        boolean isStrict = builder.getApiConfig().isStrict();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map<String, String> replacementMap = builder.getReplaceClassMap();
        Map<String, String> paramTagMap = DocUtil.getParamsComments(javaMethod, "param", className);
        Map<String, String> paramsComments = DocUtil.getParamsComments(javaMethod, "param", null);
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        List parameterList = javaMethod.getParameters();
        if (parameterList.size() < 1) {
            return ApiMethodReqParam.builder().setPathParams(new ArrayList<ApiParam>(0)).setQueryParams(paramList).setRequestParams(new ArrayList<ApiParam>(0));
        }
        Map<String, String> constantsMap = builder.getConstantsMap();
        boolean requestFieldToUnderline = builder.getApiConfig().isRequestFieldToUnderline();
        Set<String> ignoreSets = this.ignoreParamsSets(javaMethod);
        Map<String, JavaType> actualTypesMap = docJavaMethod.getActualTypesMap();
        block0: for (JavaParameter parameter : parameterList) {
            String[] gicNameArr;
            boolean queryParam;
            String paramName = parameter.getName();
            if (ignoreSets.contains(paramName)) continue;
            JavaType javaType = parameter.getType();
            if (Objects.nonNull(actualTypesMap) && Objects.nonNull(actualTypesMap.get(javaType.getCanonicalName()))) {
                javaType = actualTypesMap.get(javaType.getCanonicalName());
            }
            String typeName = javaType.getGenericCanonicalName();
            String simpleName = javaType.getValue().toLowerCase();
            String fullTypeName = javaType.getFullyQualifiedName();
            String simpleTypeName = javaType.getValue();
            String commentClass = paramTagMap.get(paramName);
            String rewriteClassName = this.getRewriteClassName(replacementMap, fullTypeName, commentClass);
            if (DocUtil.isClassName(rewriteClassName)) {
                typeName = rewriteClassName;
                fullTypeName = DocClassUtil.getSimpleName(rewriteClassName);
            }
            if (JavaClassValidateUtil.isMvcIgnoreParams(typeName, builder.getApiConfig().getIgnoreRequestParams())) continue;
            fullTypeName = DocClassUtil.rewriteRequestParam(fullTypeName);
            typeName = DocClassUtil.rewriteRequestParam(typeName);
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(fullTypeName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @QueryParam for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            String comment = this.paramCommentResolve(paramTagMap.get(paramName));
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            if (JavaClassValidateUtil.isFile(typeName)) {
                ApiParam param = ApiParam.of().setField(paramName).setType("file").setId(paramList.size() + 1).setQueryParam(true).setRequired(true).setVersion("-").setDesc(comment);
                if (typeName.contains("[]") || typeName.endsWith(">")) {
                    comment = comment + "(array of file)";
                    param.setDesc(comment);
                    param.setHasItems(true);
                }
                paramList.add(param);
                continue;
            }
            String mockValue = this.createMockValue(paramsComments, paramName, typeName, simpleTypeName);
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(fullTypeName);
            List annotations = parameter.getAnnotations();
            List<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations);
            String strRequired = "false";
            boolean isPathVariable = false;
            boolean isRequestBody = false;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                if ("HeaderParam".equals(annotationName)) continue block0;
                if (!"PathParam".equals(annotationName)) continue;
                isPathVariable = true;
                paramName = this.getParamName(paramName, annotation);
                for (Map.Entry<String, String> entry : constantsMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (paramName.contains(key)) {
                        paramName = paramName.replace(key, value);
                    }
                    if (!mockValue.contains(key)) continue;
                    mockValue = mockValue.replace(key, value);
                }
            }
            boolean required = false;
            boolean bl = queryParam = !isPathVariable;
            if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                ApiParam param;
                JavaClass gicJavaClass;
                String gicName;
                if (JavaClassValidateUtil.isCollection(typeName)) {
                    typeName = typeName + "<T>";
                }
                if (JavaClassValidateUtil.isArray(gicName = (gicNameArr = DocClassUtil.getSimpleGicName(typeName))[0])) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if ((gicJavaClass = builder.getJavaProjectBuilder().getClassByName(gicName)).isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(gicJavaClass, Boolean.TRUE);
                    param = ApiParam.of().setField(paramName).setDesc(comment + ",[array of enum]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setType("array").setValue(String.valueOf(value));
                    paramList.add(param);
                    continue;
                }
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    String shortSimple = DocClassUtil.processTypeNameForParams(gicName);
                    param = ApiParam.of().setField(paramName).setDesc(comment + ",[array of " + shortSimple + "]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setType("array").setValue(DocUtil.getValByTypeAndFieldName(gicName, paramName));
                    paramList.add(param);
                    continue;
                }
                throw new RuntimeException("Dubbo Rest can't support binding Collection on method " + javaMethod.getName() + ",Check it in " + javaMethod.getDeclaringClass().getCanonicalName());
            }
            if (JavaClassValidateUtil.isPrimitive(fullTypeName)) {
                ApiParam param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(mockValue).setDesc(comment).setRequired(required).setVersion("-");
                paramList.add(param);
                continue;
            }
            if (JavaClassValidateUtil.isMap(fullTypeName)) {
                log.warning("When using smart-doc, it is not recommended to use Map to receive parameters, Check it in " + javaMethod.getDeclaringClass().getCanonicalName() + "#" + javaMethod.getName());
                if (JavaClassValidateUtil.isMap(typeName)) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    continue;
                }
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                if (JavaClassValidateUtil.isPrimitive(gicNameArr[1])) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    continue;
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[1], "", 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE));
                continue;
            }
            if (javaClass.isEnum()) {
                String o = JavaClassUtil.getEnumParams(javaClass);
                Object value = JavaClassUtil.getEnumValue(javaClass, true);
                ApiParam param = ApiParam.of().setField(paramName).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(String.valueOf(value)).setType("enum").setDesc(StringUtil.removeQuotes((String)o)).setRequired(required).setVersion("-").setEnumValues(JavaClassUtil.getEnumValues(javaClass));
                paramList.add(param);
                continue;
            }
            paramList.addAll(ParamsBuildHelper.buildParams(typeName, "", 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE));
        }
        ArrayList<ApiParam> pathParams = new ArrayList<ApiParam>();
        ArrayList<ApiParam> queryParams = new ArrayList<ApiParam>();
        ArrayList<ApiParam> bodyParams = new ArrayList<ApiParam>();
        for (ApiParam param : paramList) {
            param.setValue(StringUtil.removeDoubleQuotes((String)param.getValue()));
            if (param.isPathParam()) {
                param.setId(pathParams.size() + 1);
                pathParams.add(param);
                continue;
            }
            param.setId(queryParams.size() + 1);
            queryParams.add(param);
        }
        return ApiMethodReqParam.builder().setRequestParams(bodyParams).setPathParams(pathParams).setQueryParams(queryParams);
    }

    private String getParamName(String paramName, JavaAnnotation annotation) {
        AnnotationValue annotationOfName;
        AnnotationValue annotationValue = annotation.getProperty("value");
        if (Objects.nonNull(annotationValue)) {
            paramName = StringUtil.removeQuotes((String)annotationValue.toString());
        }
        if (Objects.nonNull(annotationOfName = annotation.getProperty("name"))) {
            paramName = StringUtil.removeQuotes((String)annotationOfName.toString());
        }
        return paramName;
    }

    private String createMockValue(Map<String, String> paramsComments, String paramName, String typeName, String simpleTypeName) {
        String mockValue = "";
        if (JavaClassValidateUtil.isPrimitive(typeName) && StringUtil.isEmpty((String)(mockValue = Objects.nonNull(mockValue = paramsComments.get(paramName)) && mockValue.contains("|") ? mockValue.substring(mockValue.lastIndexOf("|") + 1) : ""))) {
            mockValue = DocUtil.getValByTypeAndFieldName(simpleTypeName, paramName, Boolean.TRUE);
        }
        return mockValue;
    }

    private static void setTornaArrayTags(List<JavaParameter> javaParameters, ApiMethodDoc apiMethodDoc, JavaClass returnClass) {
        apiMethodDoc.setIsResponseArray(0);
        apiMethodDoc.setIsRequestArray(0);
        if (JavaClassValidateUtil.isCollection(returnClass.getFullyQualifiedName()) || JavaClassValidateUtil.isArray(returnClass.getFullyQualifiedName())) {
            apiMethodDoc.setIsResponseArray(1);
            String typeName = returnClass.getGenericFullyQualifiedName();
            String gicType = JaxrsDocBuildTemplate.getType(typeName);
            String simpleGicType = gicType.substring(gicType.lastIndexOf(".") + 1).toLowerCase();
            apiMethodDoc.setResponseArrayType(JavaClassValidateUtil.isPrimitive(gicType) ? simpleGicType : "object");
        }
        if (CollectionUtil.isNotEmpty(javaParameters)) {
            for (JavaParameter parameter : javaParameters) {
                String typeName = parameter.getType().getGenericFullyQualifiedName();
                String name = parameter.getType().getFullyQualifiedName();
                String gicType = JaxrsDocBuildTemplate.getType(typeName);
                String simpleGicType = gicType.substring(gicType.lastIndexOf(".") + 1).toLowerCase();
                if (!JavaClassValidateUtil.isCollection(name) && !JavaClassValidateUtil.isArray(name)) continue;
                boolean hasRequestBody = false;
                List annotations = parameter.getAnnotations();
                for (JavaAnnotation annotation : annotations) {
                    if (!"org.springframework.web.bind.annotation.RequestBody".equals(annotation.getType().getName())) continue;
                    hasRequestBody = true;
                    break;
                }
                if (!hasRequestBody && javaParameters.size() > 1) {
                    return;
                }
                apiMethodDoc.setIsRequestArray(1);
                if (JavaClassValidateUtil.isPrimitive(gicType)) {
                    apiMethodDoc.setRequestArrayType(simpleGicType);
                    continue;
                }
                apiMethodDoc.setRequestArrayType("object");
            }
        }
    }

    private ApiRequestExample buildReqJson(DocJavaMethod javaMethod, ApiMethodDoc apiMethodDoc, String methodType, ProjectDocConfigBuilder configBuilder) {
        String exampleBody;
        CurlRequest curlRequest;
        String url;
        JavaMethod method = javaMethod.getJavaMethod();
        LinkedHashMap<String, String> pathParamsMap = new LinkedHashMap<String, String>();
        List methodAnnotations = method.getAnnotations();
        List parameterList = method.getParameters();
        List<ApiReqParam> reqHeaderList = apiMethodDoc.getRequestHeaders();
        if (parameterList.size() < 1) {
            CurlRequest curlRequest2 = CurlRequest.builder().setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(apiMethodDoc.getUrl());
            String format = CurlUtil.toCurl(curlRequest2);
            return ApiRequestExample.builder().setUrl(apiMethodDoc.getUrl()).setExampleBody(format);
        }
        Set<String> ignoreSets = this.ignoreParamsSets(method);
        Map<String, JavaType> actualTypesMap = javaMethod.getActualTypesMap();
        Map<String, String> constantsMap = configBuilder.getConstantsMap();
        boolean requestFieldToUnderline = configBuilder.getApiConfig().isRequestFieldToUnderline();
        Map<String, String> replacementMap = configBuilder.getReplaceClassMap();
        Map<String, String> paramsComments = DocUtil.getParamsComments(method, "param", null);
        ArrayList<FormData> formDataList = new ArrayList<FormData>();
        ApiRequestExample requestExample = ApiRequestExample.builder();
        for (JavaParameter parameter : parameterList) {
            String paramName;
            JavaType javaType = parameter.getType();
            if (Objects.nonNull(actualTypesMap) && Objects.nonNull(actualTypesMap.get(javaType.getCanonicalName()))) {
                javaType = actualTypesMap.get(javaType.getCanonicalName());
            }
            if (ignoreSets.contains(paramName = parameter.getName())) continue;
            String typeName = javaType.getFullyQualifiedName();
            String gicTypeName = javaType.getGenericCanonicalName();
            String commentClass = paramsComments.get(paramName);
            if (Objects.nonNull(commentClass) && commentClass.contains("ignore")) continue;
            String rewriteClassName = this.getRewriteClassName(replacementMap, typeName, commentClass);
            if (DocUtil.isClassName(rewriteClassName)) {
                gicTypeName = rewriteClassName;
                typeName = DocClassUtil.getSimpleName(rewriteClassName);
            }
            if (JavaClassValidateUtil.isMvcIgnoreParams(typeName, configBuilder.getApiConfig().getIgnoreRequestParams())) continue;
            String simpleTypeName = javaType.getValue();
            typeName = DocClassUtil.rewriteRequestParam(typeName);
            gicTypeName = DocClassUtil.rewriteRequestParam(gicTypeName);
            if (JavaClassValidateUtil.isCollection(typeName)) {
                apiMethodDoc.setListParam(true);
            }
            JavaClass javaClass = configBuilder.getJavaProjectBuilder().getClassByName(typeName);
            String[] globGicName = DocClassUtil.getSimpleGicName(gicTypeName);
            String comment = this.paramCommentResolve(paramsComments.get(paramName));
            String mockValue = this.createMockValue(paramsComments, paramName, typeName, simpleTypeName);
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            List annotations = parameter.getAnnotations();
            List<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations);
            boolean paramAdded = false;
            for (JavaAnnotation annotation : methodAnnotations) {
                FormData formData;
                Object value;
                AnnotationValue avalue;
                String annotationName = annotation.getType().getValue();
                if (("Consumes".equals(annotationName) || paramAdded) && ((avalue = annotation.getProperty("value")) != null && avalue.toString().contains("json") || avalue.toString().contains("JSON"))) {
                    paramName = this.getParamName(paramName, annotation);
                    for (Map.Entry<String, String> entry : constantsMap.entrySet()) {
                        String key = entry.getKey();
                        String value2 = entry.getValue();
                        if (paramName.contains(key)) {
                            paramName = paramName.replace(key, value2);
                        }
                        if (!mockValue.contains(key)) continue;
                        mockValue = mockValue.replace(key, value2);
                    }
                    apiMethodDoc.setContentType("application/json; charset=utf-8");
                    if (Objects.nonNull(configBuilder.getApiConfig().getRequestBodyAdvice()) && Objects.isNull(method.getTagByName("ignoreRequestBodyAdvice"))) {
                        String requestBodyAdvice = configBuilder.getApiConfig().getRequestBodyAdvice().getClassName();
                        typeName = configBuilder.getApiConfig().getRequestBodyAdvice().getClassName();
                        gicTypeName = requestBodyAdvice + "<" + gicTypeName + ">";
                    }
                    if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("{\"").append(paramName).append("\":").append(DocUtil.handleJsonStr(mockValue)).append("}");
                        requestExample.setJsonBody(JsonUtil.toPrettyFormat(builder.toString())).setJson(true);
                    } else {
                        String json = JsonBuildHelper.buildJson(typeName, gicTypeName, Boolean.FALSE, 0, new HashMap<String, String>(), groupClasses, configBuilder);
                        requestExample.setJsonBody(JsonUtil.toPrettyFormat(json)).setJson(true);
                    }
                    paramAdded = true;
                }
                if ("PathParam".equals(annotationName)) {
                    if (javaClass.isEnum()) {
                        value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                        mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                    }
                    pathParamsMap.put(paramName, mockValue);
                    paramAdded = true;
                }
                if (paramAdded) continue;
                if (JavaClassValidateUtil.isFile(gicTypeName)) {
                    apiMethodDoc.setContentType("multipart/form-data");
                    formData = new FormData();
                    formData.setKey(paramName);
                    formData.setType("file");
                    formData.setDescription(comment);
                    formData.setValue(mockValue);
                    formDataList.add(formData);
                    continue;
                }
                if (JavaClassValidateUtil.isPrimitive(typeName)) {
                    formData = new FormData();
                    formData.setKey(paramName);
                    formData.setDescription(comment);
                    formData.setType("text");
                    formData.setValue(mockValue);
                    formDataList.add(formData);
                    continue;
                }
                if (JavaClassValidateUtil.isArray(typeName) || JavaClassValidateUtil.isCollection(typeName)) {
                    String gicName = globGicName[0];
                    if (JavaClassValidateUtil.isArray(gicName)) {
                        gicName = gicName.substring(0, gicName.indexOf("["));
                    }
                    if (!JavaClassValidateUtil.isPrimitive(gicName) && !configBuilder.getJavaProjectBuilder().getClassByName(gicName).isEnum()) {
                        throw new RuntimeException("Dubbo rest can't support binding Collection on method " + method.getName() + "Check it in " + method.getDeclaringClass().getCanonicalName());
                    }
                    FormData formData2 = new FormData();
                    formData2.setKey(paramName);
                    if (!paramName.contains("[]")) {
                        formData2.setKey(paramName + "[]");
                    }
                    formData2.setDescription(comment);
                    formData2.setType("text");
                    formData2.setValue(RandomUtil.randomValueByType((String)gicName));
                    formDataList.add(formData2);
                    continue;
                }
                if (javaClass.isEnum()) {
                    value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                    String strVal = StringUtil.removeQuotes((String)String.valueOf(value));
                    FormData formData3 = new FormData();
                    formData3.setKey(paramName);
                    formData3.setType("text");
                    formData3.setDescription(comment);
                    formData3.setValue(strVal);
                    formDataList.add(formData3);
                    continue;
                }
                formDataList.addAll(FormDataBuildHelper.getFormData(gicTypeName, new HashMap<String, String>(), 0, configBuilder, ""));
            }
        }
        requestExample.setFormDataList(formDataList);
        String[] paths = apiMethodDoc.getPath().split(";");
        String path = paths[0];
        if (Methods.POST.getValue().equals(methodType) || Methods.PUT.getValue().equals(methodType)) {
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            String body = UrlUtil.urlJoin((String)"", DocUtil.formDataToMap(formDataList)).replace("?", "");
            body = StringUtil.removeQuotes((String)body);
            url = apiMethodDoc.getServerUrl() + "/" + path;
            url = UrlUtil.simplifyUrl((String)url);
            if (requestExample.isJson()) {
                if (StringUtil.isNotEmpty((String)body)) {
                    url = url + "?" + body;
                }
                curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            } else {
                curlRequest = StringUtil.isNotEmpty((String)body) ? CurlRequest.builder().setBody(body).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url) : CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            }
            requestExample.setExampleBody(exampleBody).setUrl(url);
        } else {
            pathParamsMap.putAll(DocUtil.formDataToMap(formDataList));
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            url = UrlUtil.urlJoin((String)path, pathParamsMap);
            url = StringUtil.removeQuotes((String)url);
            url = apiMethodDoc.getServerUrl() + "/" + url;
            url = UrlUtil.simplifyUrl((String)url);
            curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
            exampleBody = CurlUtil.toCurl(curlRequest);
            requestExample.setExampleBody(exampleBody).setJsonBody("").setUrl(url);
        }
        return requestExample;
    }

    private String getRewriteClassName(Map<String, String> replacementMap, String fullTypeName, String commentClass) {
        String[] comments;
        String rewriteClassName;
        if (Objects.nonNull(commentClass) && !"No comments found.".equals(commentClass) && DocUtil.isClassName(rewriteClassName = (comments = commentClass.split("\\|"))[comments.length - 1])) {
            return rewriteClassName;
        }
        return replacementMap.get(fullTypeName);
    }

    private static String getType(String typeName) {
        String gicType = typeName.contains("<") ? typeName.substring(typeName.indexOf("<") + 1, typeName.lastIndexOf(">")) : typeName;
        if (gicType.contains("[")) {
            gicType = gicType.substring(0, gicType.indexOf("["));
        }
        return gicType;
    }

    private boolean checkController(JavaClass cls) {
        if (cls.isAnnotation() || cls.isEnum()) {
            return false;
        }
        JavaClass superClass = cls.getSuperJavaClass();
        ArrayList classAnnotations = new ArrayList();
        if (Objects.nonNull(superClass)) {
            classAnnotations.addAll(superClass.getAnnotations());
        }
        classAnnotations.addAll(cls.getAnnotations());
        for (JavaAnnotation annotation : classAnnotations) {
            String name = annotation.getType().getValue();
            if (!"Path".equals(name)) continue;
            return true;
        }
        List docletTags = cls.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"dubboRest".equals(value)) continue;
            return true;
        }
        return false;
    }
}

