/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.CollectionUtil;
import com.power.doc.model.ApiParam;
import java.util.ArrayList;
import java.util.List;

public class ApiParamTreeUtil {
    public static List<ApiParam> apiParamToTree(List<ApiParam> apiParamList) {
        if (CollectionUtil.isEmpty(apiParamList)) {
            return new ArrayList<ApiParam>(0);
        }
        ArrayList<ApiParam> params = new ArrayList<ApiParam>();
        for (ApiParam apiParam : apiParamList) {
            apiParam.setField(apiParam.getField().replaceAll("\u2514\u2500", "").replaceAll("&nbsp;", ""));
            if (apiParam.getPid() != 0) continue;
            params.add(apiParam);
        }
        for (ApiParam apiParam : params) {
            apiParam.setChildren(ApiParamTreeUtil.getChild(apiParam.getId(), apiParamList, 0));
        }
        return params;
    }

    private static List<ApiParam> getChild(int id, List<ApiParam> apiParamList, int counter) {
        ArrayList<ApiParam> childList = new ArrayList<ApiParam>();
        if (counter > 7) {
            return childList;
        }
        for (ApiParam param : apiParamList) {
            if (param.getPid() != id) continue;
            childList.add(param);
        }
        ++counter;
        for (ApiParam param : childList) {
            param.setChildren(ApiParamTreeUtil.getChild(param.getId(), apiParamList, counter));
        }
        if (childList.size() == 0) {
            return new ArrayList<ApiParam>(0);
        }
        return childList;
    }
}

