/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.request.CurlRequest;

public class CurlUtil {
    public static String toCurl(CurlRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append("curl");
        sb.append(" -X");
        sb.append(" ").append(request.getType());
        if (request.getUrl().indexOf("https") == 0) {
            sb.append(" -k");
        }
        if (StringUtil.isNotEmpty((String)request.getContentType()) && !"application/x-www-form-urlencoded;charset=utf-8".equals(request.getContentType())) {
            sb.append(" -H");
            sb.append(" 'Content-Type: ").append(request.getContentType()).append("'");
        }
        if (CollectionUtil.isNotEmpty(request.getReqHeaders())) {
            for (ApiReqParam reqHeader : request.getReqHeaders()) {
                sb.append(" -H");
                if (StringUtil.isEmpty((String)reqHeader.getValue())) {
                    sb.append(" '" + reqHeader.getName() + "'");
                    continue;
                }
                sb.append(" '" + reqHeader.getName() + ':' + reqHeader.getValue() + "'");
            }
        }
        sb.append(" -i");
        sb.append(" ").append(request.getUrl());
        if (StringUtil.isNotEmpty((String)request.getBody())) {
            sb.append(" --data");
            sb.append(" '" + request.getBody() + "'");
        }
        return sb.toString();
    }
}

