/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.CollectionUtil;
import java.util.List;
import java.util.Objects;

public class JavaClassValidateUtil {
    public static boolean isPrimitiveArray(String type0) {
        String type = type0.contains("java.lang") ? type0.substring(type0.lastIndexOf(".") + 1, type0.length()) : type0;
        switch (type = type.toLowerCase()) {
            case "integer[]": 
            case "void": 
            case "int[]": 
            case "long[]": 
            case "double[]": 
            case "float[]": 
            case "short[]": 
            case "bigdecimal[]": 
            case "char[]": 
            case "string[]": 
            case "boolean[]": 
            case "byte[]": {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimitive(String type0) {
        if (Objects.isNull(type0)) {
            return true;
        }
        String type = type0.contains("java.lang") ? type0.substring(type0.lastIndexOf(".") + 1, type0.length()) : type0;
        switch (type = type.toLowerCase()) {
            case "integer": 
            case "void": 
            case "int": 
            case "long": 
            case "double": 
            case "float": 
            case "short": 
            case "bigdecimal": 
            case "char": 
            case "string": 
            case "number": 
            case "boolean": 
            case "byte": 
            case "uuid": 
            case "character": 
            case "java.sql.timestamp": 
            case "java.util.date": 
            case "java.time.localdatetime": 
            case "java.time.localtime": 
            case "localdatetime": 
            case "localdate": 
            case "zoneddatetime": 
            case "java.time.localdate": 
            case "java.time.zoneddatetime": 
            case "java.math.bigdecimal": 
            case "java.math.biginteger": 
            case "java.util.uuid": 
            case "java.util.UUID": 
            case "java.io.serializable": 
            case "java.lang.character": {
                return true;
            }
        }
        return false;
    }

    public static boolean isCollection(String type) {
        switch (type) {
            case "java.util.List": 
            case "java.util.LinkedList": 
            case "java.util.ArrayList": 
            case "java.util.Set": 
            case "java.util.TreeSet": 
            case "java.util.HashSet": 
            case "java.util.SortedSet": 
            case "java.util.Collection": 
            case "java.util.ArrayDeque": 
            case "java.util.PriorityQueue": {
                return true;
            }
        }
        return false;
    }

    public static boolean isMap(String type) {
        switch (type) {
            case "java.util.Map": 
            case "java.util.SortedMap": 
            case "java.util.TreeMap": 
            case "java.util.LinkedHashMap": 
            case "java.util.HashMap": 
            case "java.util.concurrent.ConcurrentHashMap": 
            case "java.util.concurrent.ConcurrentMap": 
            case "java.util.Properties": 
            case "java.util.Hashtable": {
                return true;
            }
        }
        return false;
    }

    public static boolean isArray(String type) {
        return type.endsWith("[]");
    }

    public static boolean isJSR303Required(String annotationSimpleName) {
        switch (annotationSimpleName) {
            case "NotNull": 
            case "NotEmpty": 
            case "NotBlank": 
            case "Required": {
                return true;
            }
        }
        return false;
    }

    public static boolean isRequiredTag(String tagName) {
        switch (tagName) {
            case "required": {
                return true;
            }
        }
        return false;
    }

    public static boolean isIgnoreTag(String tagName) {
        switch (tagName) {
            case "ignore": {
                return true;
            }
        }
        return false;
    }

    public static boolean isFileDownloadResource(String typeName) {
        switch (typeName) {
            case "org.springframework.core.io.Resource": 
            case "org.springframework.core.io.InputStreamSource": 
            case "org.springframework.core.io.ByteArrayResource": {
                return true;
            }
        }
        return false;
    }

    public static boolean isMvcIgnoreParams(String paramType, List<String> ignoreParams) {
        if (CollectionUtil.isNotEmpty(ignoreParams) && ignoreParams.contains(paramType)) {
            return true;
        }
        switch (paramType) {
            case "org.springframework.ui.Model": 
            case "org.springframework.ui.ModelMap": 
            case "org.springframework.web.servlet.ModelAndView": 
            case "org.springframework.web.servlet.mvc.support.RedirectAttributesModelMap": 
            case "org.springframework.validation.BindingResult": 
            case "javax.servlet.http.HttpServletRequest": 
            case "javax.servlet.http.HttpServlet": 
            case "javax.servlet.http.HttpSession": 
            case "javax.servlet.http.HttpServletResponse": 
            case "org.springframework.web.context.request.WebRequest": 
            case "org.springframework.web.reactive.function.server.ServerRequest": 
            case "org.springframework.web.multipart.MultipartHttpServletRequest": 
            case "org.springframework.http.HttpHeaders": 
            case "org.springframework.core.io.Resource": 
            case "org.springframework.core.io.InputStreamSource": 
            case "org.springframework.core.io.ByteArrayResource": {
                return true;
            }
        }
        return false;
    }

    public static boolean isIgnoreFieldTypes(String typeName) {
        switch (typeName) {
            case "org.slf4j.Logger": 
            case "org.apache.ibatis.logging.Log": 
            case "java.lang.Class": {
                return true;
            }
        }
        return false;
    }

    public static boolean isFile(String typeName) {
        switch (typeName) {
            case "org.springframework.web.multipart.MultipartFile": 
            case "org.springframework.web.multipart.MultipartFile[]": 
            case "java.util.List<org.springframework.web.multipart.MultipartFile>": 
            case "org.springframework.web.multipart.commons.CommonsMultipartFile": 
            case "org.springframework.web.multipart.commons.CommonsMultipartFile[]": 
            case "java.util.List<org.springframework.web.multipart.commons.CommonsMultipartFile>": {
                return true;
            }
        }
        return false;
    }

    public static boolean isReactor(String typeName) {
        switch (typeName) {
            case "reactor.core.publisher.Mono": 
            case "reactor.core.publisher.Flux": {
                return true;
            }
        }
        return false;
    }
}

