/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.service;

import com.github.tobato.fastdfs.conn.TrackerConnectionManager;
import com.github.tobato.fastdfs.domain.GroupState;
import com.github.tobato.fastdfs.domain.StorageNode;
import com.github.tobato.fastdfs.domain.StorageNodeInfo;
import com.github.tobato.fastdfs.domain.StorageState;
import com.github.tobato.fastdfs.proto.tracker.TrackerDeleteStorageCommand;
import com.github.tobato.fastdfs.proto.tracker.TrackerGetFetchStorageCommand;
import com.github.tobato.fastdfs.proto.tracker.TrackerGetStoreStorageCommand;
import com.github.tobato.fastdfs.proto.tracker.TrackerListGroupsCommand;
import com.github.tobato.fastdfs.proto.tracker.TrackerListStoragesCommand;
import com.github.tobato.fastdfs.service.TrackerClient;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultTrackerClient
implements TrackerClient {
    @Autowired
    private TrackerConnectionManager trackerConnectionManager;

    @Override
    public StorageNode getStoreStorage() {
        TrackerGetStoreStorageCommand command = new TrackerGetStoreStorageCommand();
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public StorageNode getStoreStorage(String groupName) {
        TrackerGetStoreStorageCommand command = StringUtils.isBlank((CharSequence)groupName) ? new TrackerGetStoreStorageCommand() : new TrackerGetStoreStorageCommand(groupName);
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public StorageNodeInfo getFetchStorage(String groupName, String filename) {
        TrackerGetFetchStorageCommand command = new TrackerGetFetchStorageCommand(groupName, filename, false);
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public StorageNodeInfo getUpdateStorage(String groupName, String filename) {
        TrackerGetFetchStorageCommand command = new TrackerGetFetchStorageCommand(groupName, filename, true);
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public List<GroupState> listGroups() {
        TrackerListGroupsCommand command = new TrackerListGroupsCommand();
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public List<StorageState> listStorages(String groupName) {
        TrackerListStoragesCommand command = new TrackerListStoragesCommand(groupName);
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public List<StorageState> listStorages(String groupName, String storageIpAddr) {
        TrackerListStoragesCommand command = new TrackerListStoragesCommand(groupName, storageIpAddr);
        return this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }

    @Override
    public void deleteStorage(String groupName, String storageIpAddr) {
        TrackerDeleteStorageCommand command = new TrackerDeleteStorageCommand(groupName, storageIpAddr);
        this.trackerConnectionManager.executeFdfsTrackerCmd(command);
    }
}

