/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptmavenplugin.mojo;

import com.ulisesbocchio.jasyptmavenplugin.encrypt.EncryptionService;
import com.ulisesbocchio.jasyptmavenplugin.mojo.Application;
import java.util.HashMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

public abstract class AbstractJasyptMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(AbstractJasyptMojo.class);
    @Parameter(property="jasypt.plugin.encrypt.prefix", defaultValue="ENC(")
    private String encryptPrefix = "ENC(";
    @Parameter(property="jasypt.plugin.encrypt.suffix", defaultValue=")")
    private String encryptSuffix = ")";
    @Parameter(property="jasypt.plugin.decrypt.prefix", defaultValue="DEC(")
    private String decryptPrefix = "DEC(";
    @Parameter(property="jasypt.plugin.decrypt.suffix", defaultValue=")")
    private String decryptSuffix = ")";
    private Environment environment;

    protected Environment getEnvironment() {
        return this.environment;
    }

    public void execute() throws MojoExecutionException {
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("spring.config.location", "optional:file:./src/main/resources/");
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{Application.class}).bannerMode(Banner.Mode.OFF).properties(defaultProperties).run(new String[0]);
        this.environment = context.getEnvironment();
        CharSequence[] activeProfiles = context.getEnvironment().getActiveProfiles();
        String profiles = activeProfiles.length != 0 ? String.join((CharSequence)",", activeProfiles) : "Default";
        log.info("Active Profiles: {}", (Object)profiles);
        StringEncryptor encryptor = (StringEncryptor)context.getBean(StringEncryptor.class);
        this.run(new EncryptionService(encryptor), context, this.encryptPrefix, this.encryptSuffix, this.decryptPrefix, this.decryptSuffix);
    }

    abstract void run(EncryptionService var1, ConfigurableApplicationContext var2, String var3, String var4, String var5, String var6) throws MojoExecutionException;
}

