/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.shape;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxITextShape;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxCurve;
import com.mxgraph.util.mxLine;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxCurveLabelShape
implements mxITextShape {
    protected String lastValue;
    protected Font lastFont;
    protected List<mxPoint> lastPoints;
    protected mxCurve curve;
    protected mxCellState state;
    protected LabelGlyphCache[] labelGlyphs;
    protected double labelSize;
    protected mxRectangle labelBounds;
    protected LabelPosition labelPosition = new LabelPosition();
    public static double LABEL_BUFFER = 30.0;
    public static double CURVE_TEXT_STRETCH_FACTOR = 20.0;
    public static mxRectangle INVALID_GLYPH_BOUNDS = new mxRectangle(0.0, 0.0, 0.0, 0.0);
    public int centerVisibleIndex = 0;
    public static Object FONT_FRACTIONALMETRICS = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
    public GlyphVector[] rtlGlyphVectors;
    public static FontRenderContext frc = new FontRenderContext(null, false, false);
    protected boolean rotationEnabled = true;

    public mxCurveLabelShape(mxCellState state, mxCurve value) {
        this.state = state;
        this.curve = value;
    }

    public boolean getRotationEnabled() {
        return this.rotationEnabled;
    }

    public void setRotationEnabled(boolean value) {
        this.rotationEnabled = value;
    }

    @Override
    public void paintShape(mxGraphics2DCanvas canvas, String text, mxCellState state, Map<String, Object> style) {
        Rectangle rect = state.getLabelBounds().getRectangle();
        Graphics2D g = canvas.getGraphics();
        if (this.labelGlyphs == null) {
            this.updateLabelBounds(text, style);
        }
        if (this.labelGlyphs != null && (g.getClipBounds() == null || g.getClipBounds().intersects(rect))) {
            float opacity = mxUtils.getFloat(style, mxConstants.STYLE_OPACITY, 100.0f);
            Graphics2D previousGraphics = g;
            g = canvas.createTemporaryGraphics(style, opacity, state);
            Font font = mxUtils.getFont(style, canvas.getScale());
            g.setFont(font);
            Color fontColor = mxUtils.getColor(style, mxConstants.STYLE_FONTCOLOR, Color.black);
            g.setColor(fontColor);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, FONT_FRACTIONALMETRICS);
            for (int j = 0; j < this.labelGlyphs.length; ++j) {
                mxLine parallel = this.labelGlyphs[j].glyphGeometry;
                if (!this.labelGlyphs[j].visible || parallel == null || parallel == mxCurve.INVALID_POSITION) continue;
                mxPoint parallelEnd = parallel.getEndPoint();
                double x = parallelEnd.getX();
                double rotation = Math.atan(parallelEnd.getY() / x);
                if (x < 0.0) {
                    rotation += Math.PI;
                }
                AffineTransform old = g.getTransform();
                g.translate(parallel.getX(), parallel.getY());
                g.rotate(rotation);
                Shape letter = this.labelGlyphs[j].glyphShape;
                g.fill(letter);
                g.setTransform(old);
            }
            g.dispose();
            g = previousGraphics;
        }
    }

    public mxRectangle updateLabelBounds(String label, Map<String, Object> style) {
        double scale = this.state.getView().getScale();
        Font font = mxUtils.getFont(style, scale);
        FontMetrics fm = mxUtils.getFontMetrics(font);
        int descent = 0;
        int ascent = 0;
        if (fm != null) {
            descent = fm.getDescent();
            ascent = fm.getAscent();
        }
        if (this.labelGlyphs == null || !label.equals(this.lastValue)) {
            this.labelGlyphs = new LabelGlyphCache[label.length()];
        }
        if (!label.equals(this.lastValue) || !font.equals(this.lastFont)) {
            char[] labelChars = label.toCharArray();
            ArrayList<LabelGlyphCache> glyphList = new ArrayList<LabelGlyphCache>();
            boolean bidiRequired = Bidi.requiresBidi(labelChars, 0, labelChars.length);
            this.labelSize = 0.0;
            if (bidiRequired) {
                Bidi bidi = new Bidi(label, -2);
                int runCount = bidi.getRunCount();
                if (this.rtlGlyphVectors == null || this.rtlGlyphVectors.length != runCount) {
                    this.rtlGlyphVectors = new GlyphVector[runCount];
                }
                for (int i = 0; i < bidi.getRunCount(); ++i) {
                    String labelSection = label.substring(bidi.getRunStart(i), bidi.getRunLimit(i));
                    this.rtlGlyphVectors[i] = font.layoutGlyphVector(frc, labelSection.toCharArray(), 0, labelSection.length(), 1);
                }
                int charCount = 0;
                for (GlyphVector gv : this.rtlGlyphVectors) {
                    float vectorOffset = 0.0f;
                    for (int j = 0; j < gv.getNumGlyphs(); ++j) {
                        mxRectangle size;
                        Shape shape = gv.getGlyphOutline(j, -vectorOffset, 0.0f);
                        LabelGlyphCache qlyph = new LabelGlyphCache();
                        glyphList.add(qlyph);
                        qlyph.glyphShape = shape;
                        qlyph.labelGlyphBounds = size = new mxRectangle(gv.getGlyphLogicalBounds(j).getBounds2D());
                        this.labelSize += size.getWidth();
                        vectorOffset = (float)((double)vectorOffset + size.getWidth());
                        ++charCount;
                    }
                }
            } else {
                int characterLen;
                this.rtlGlyphVectors = null;
                BreakIterator it = BreakIterator.getCharacterInstance(Locale.getDefault());
                it.setText(label);
                for (int i = 0; i < label.length(); i += characterLen) {
                    int next = it.next();
                    characterLen = 1;
                    if (next != -1) {
                        characterLen = next - i;
                    }
                    String glyph = label.substring(i, i + characterLen);
                    LabelGlyphCache labelGlyph = new LabelGlyphCache();
                    glyphList.add(labelGlyph);
                    labelGlyph.glyph = glyph;
                    GlyphVector vector = font.createGlyphVector(frc, glyph);
                    labelGlyph.glyphShape = vector.getOutline();
                    if (fm == null) {
                        mxRectangle size;
                        labelGlyph.labelGlyphBounds = size = new mxRectangle(font.getStringBounds(glyph, frc));
                        this.labelSize += size.getWidth();
                        continue;
                    }
                    double width = fm.stringWidth(glyph);
                    labelGlyph.labelGlyphBounds = new mxRectangle(0.0, 0.0, width, ascent);
                    this.labelSize += width;
                }
            }
            this.lastValue = label;
            this.lastFont = font;
            this.lastPoints = this.curve.getGuidePoints();
            this.labelGlyphs = glyphList.toArray(new LabelGlyphCache[glyphList.size()]);
        }
        this.labelPosition.startBuffer = LABEL_BUFFER * scale;
        this.labelPosition.endBuffer = LABEL_BUFFER * scale;
        this.calculationLabelPosition(style, label);
        if (this.curve.isLabelReversed()) {
            double temp = this.labelPosition.startBuffer;
            this.labelPosition.startBuffer = this.labelPosition.endBuffer;
            this.labelPosition.endBuffer = temp;
        }
        double curveLength = this.curve.getCurveLength(mxCurve.LABEL_CURVE);
        double currentPos = this.labelPosition.startBuffer / curveLength;
        double endPos = 1.0 - this.labelPosition.endBuffer / curveLength;
        mxRectangle overallLabelBounds = null;
        this.centerVisibleIndex = 0;
        double currentCurveDelta = 0.0;
        double curveDeltaSignificant = 0.3;
        double curveDeltaMax = 0.5;
        mxLine nextParallel = null;
        for (int j = 0; j < this.labelGlyphs.length; ++j) {
            int ccw;
            double p1Y;
            double p1X;
            if (currentPos > endPos) {
                this.labelGlyphs[j].visible = false;
                continue;
            }
            mxLine parallel = nextParallel;
            if (currentCurveDelta > curveDeltaSignificant || nextParallel == null) {
                parallel = this.curve.getCurveParallel(mxCurve.LABEL_CURVE, currentPos);
                currentCurveDelta = 0.0;
                nextParallel = null;
            }
            this.labelGlyphs[j].glyphGeometry = parallel;
            if (parallel == mxCurve.INVALID_POSITION) continue;
            double w = this.labelGlyphs[j].labelGlyphBounds.getWidth();
            double h = this.labelGlyphs[j].labelGlyphBounds.getHeight();
            double x = parallel.getEndPoint().getX();
            double y = parallel.getEndPoint().getY();
            double minX = p1X = parallel.getX() - (double)descent * y;
            double maxX = p1X;
            double minY = p1Y = parallel.getY() + (double)descent * x;
            double maxY = p1Y;
            double p2X = p1X + (h + (double)descent) * y;
            double p2Y = p1Y - (h + (double)descent) * x;
            minX = Math.min(minX, p2X);
            maxX = Math.max(maxX, p2X);
            minY = Math.min(minY, p2Y);
            maxY = Math.max(maxY, p2Y);
            double p3X = p1X + w * x;
            double p3Y = p1Y + w * y;
            minX = Math.min(minX, p3X);
            maxX = Math.max(maxX, p3X);
            minY = Math.min(minY, p3Y);
            maxY = Math.max(maxY, p3Y);
            double p4X = p2X + w * x;
            double p4Y = p2Y + w * y;
            minX = Math.min(minX, p4X);
            maxX = Math.max(maxX, p4X);
            minY = Math.min(minY, p4Y);
            maxY = Math.max(maxY, p4Y);
            minX -= 2.0 * scale;
            minY -= 2.0 * scale;
            maxX += 2.0 * scale;
            maxY += 2.0 * scale;
            this.postprocessGlyph(this.curve, label, j, currentPos);
            double currentPosCandidate = currentPos + (this.labelGlyphs[j].labelGlyphBounds.getWidth() + this.labelPosition.defaultInterGlyphSpace) / curveLength;
            nextParallel = this.curve.getCurveParallel(mxCurve.LABEL_CURVE, currentPosCandidate);
            currentPos = currentPosCandidate;
            mxPoint nextVector = nextParallel.getEndPoint();
            double end2X = nextVector.getX();
            double end2Y = nextVector.getY();
            if (nextParallel != mxCurve.INVALID_POSITION && j + 1 < label.length()) {
                double deltaX = Math.abs(x - end2X);
                double deltaY = Math.abs(y - end2Y);
                currentCurveDelta = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            }
            if (currentCurveDelta > curveDeltaSignificant && (ccw = Line2D.relativeCCW(0.0, 0.0, x, y, end2X, end2Y)) == 1) {
                if (currentCurveDelta > curveDeltaMax) {
                    currentCurveDelta = curveDeltaMax;
                }
                double textBuffer = currentCurveDelta * CURVE_TEXT_STRETCH_FACTOR / curveLength;
                currentPos += textBuffer;
                endPos += textBuffer;
            }
            if (this.labelGlyphs[j].drawingBounds != null) {
                this.labelGlyphs[j].drawingBounds.setRect(minX, minY, maxX - minX, maxY - minY);
            } else {
                this.labelGlyphs[j].drawingBounds = new mxRectangle(minX, minY, maxX - minX, maxY - minY);
            }
            if (overallLabelBounds == null) {
                overallLabelBounds = (mxRectangle)this.labelGlyphs[j].drawingBounds.clone();
            } else {
                overallLabelBounds.add(this.labelGlyphs[j].drawingBounds);
            }
            this.labelGlyphs[j].visible = true;
            ++this.centerVisibleIndex;
        }
        this.centerVisibleIndex /= 2;
        if (overallLabelBounds == null) {
            mxLine labelCenter = this.curve.getCurveParallel(mxCurve.LABEL_CURVE, 0.5);
            overallLabelBounds = new mxRectangle(labelCenter.getX(), labelCenter.getY(), 1.0, 1.0);
        }
        this.labelBounds = overallLabelBounds;
        return overallLabelBounds;
    }

    protected void postprocessGlyph(mxCurve curve, String label, int j, double currentPos) {
    }

    public boolean intersectsRect(Rectangle rect) {
        if (this.labelBounds != null && !this.labelBounds.getRectangle().intersects(rect) || this.labelGlyphs == null) {
            return false;
        }
        for (int i = 0; i < this.labelGlyphs.length; ++i) {
            if (!this.labelGlyphs[i].visible || !rect.intersects(this.labelGlyphs[i].drawingBounds.getRectangle())) continue;
            return true;
        }
        return false;
    }

    protected void calculationLabelPosition(Map<String, Object> style, String label) {
        double curveLength = this.curve.getCurveLength(mxCurve.LABEL_CURVE);
        double availableLabelSpace = curveLength - this.labelPosition.startBuffer - this.labelPosition.endBuffer;
        this.labelPosition.startBuffer = Math.max(this.labelPosition.startBuffer, this.labelPosition.startBuffer + availableLabelSpace / 2.0 - this.labelSize / 2.0);
        this.labelPosition.endBuffer = Math.max(this.labelPosition.endBuffer, this.labelPosition.endBuffer + availableLabelSpace / 2.0 - this.labelSize / 2.0);
    }

    public mxCurve getCurve() {
        return this.curve;
    }

    public void setCurve(mxCurve curve) {
        this.curve = curve;
    }

    public mxRectangle getLabelBounds() {
        return this.labelBounds;
    }

    public mxRectangle getCenterVisiblePosition() {
        return this.labelGlyphs[this.centerVisibleIndex].drawingBounds;
    }

    public class LabelPosition {
        public double startBuffer = LABEL_BUFFER;
        public double endBuffer = LABEL_BUFFER;
        public double defaultInterGlyphSpace = 0.0;
    }

    public class LabelGlyphCache {
        public mxRectangle labelGlyphBounds;
        public mxRectangle drawingBounds;
        public String glyph;
        public mxLine glyphGeometry;
        public Shape glyphShape;
        public boolean visible;
    }
}

