/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class mxRubberband
implements MouseListener,
MouseMotionListener {
    protected Color borderColor = mxSwingConstants.RUBBERBAND_BORDERCOLOR;
    protected Color fillColor = mxSwingConstants.RUBBERBAND_FILLCOLOR;
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected transient Point first;
    protected transient Rectangle bounds;

    public mxRubberband(final mxGraphComponent graphComponent) {
        this.graphComponent = graphComponent;
        graphComponent.getGraphControl().addMouseListener(this);
        graphComponent.getGraphControl().addMouseMotionListener(this);
        graphComponent.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            public void invoke(Object source, mxEventObject evt) {
                mxRubberband.this.paintRubberband((Graphics)evt.getProperty("g"));
            }
        });
        graphComponent.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 && graphComponent.isEscapeEnabled()) {
                    mxRubberband.this.reset();
                }
            }
        });
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color value) {
        this.borderColor = value;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color value) {
        this.fillColor = value;
    }

    public boolean isRubberbandTrigger(MouseEvent e) {
        return true;
    }

    public void start(Point point) {
        this.first = point;
        this.bounds = new Rectangle(this.first);
    }

    public void reset() {
        this.first = null;
        if (this.bounds != null) {
            this.graphComponent.getGraphControl().repaint(this.bounds);
            this.bounds = null;
        }
    }

    public Object[] select(Rectangle rect, MouseEvent e) {
        return this.graphComponent.selectRegion(rect, e);
    }

    public void paintRubberband(Graphics g) {
        if (this.first != null && this.bounds != null && this.graphComponent.isSignificant(this.bounds.width, this.bounds.height)) {
            Rectangle rect = new Rectangle(this.bounds);
            g.setColor(this.fillColor);
            mxUtils.fillClippedRect(g, rect.x, rect.y, rect.width, rect.height);
            g.setColor(this.borderColor);
            --rect.width;
            --rect.height;
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!e.isConsumed() && this.isEnabled() && this.isRubberbandTrigger(e) && !e.isPopupTrigger()) {
            this.start(e.getPoint());
            e.consume();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!e.isConsumed() && this.first != null) {
            Rectangle oldBounds = new Rectangle(this.bounds);
            this.bounds = new Rectangle(this.first);
            this.bounds.add(e.getPoint());
            if (this.graphComponent.isSignificant(this.bounds.width, this.bounds.height)) {
                Rectangle tmp;
                mxGraphComponent.mxGraphControl control = this.graphComponent.getGraphControl();
                Rectangle union = new Rectangle(oldBounds);
                union.add(this.bounds);
                if (this.bounds.x != oldBounds.x) {
                    int maxleft = Math.max(this.bounds.x, oldBounds.x);
                    tmp = new Rectangle(union.x - 1, union.y, maxleft - union.x + 2, union.height);
                    control.repaint(tmp);
                }
                if (this.bounds.x + this.bounds.width != oldBounds.x + oldBounds.width) {
                    int minright = Math.min(this.bounds.x + this.bounds.width, oldBounds.x + oldBounds.width);
                    tmp = new Rectangle(minright - 1, union.y, union.x + union.width - minright + 1, union.height);
                    control.repaint(tmp);
                }
                if (this.bounds.y != oldBounds.y) {
                    int maxtop = Math.max(this.bounds.y, oldBounds.y);
                    tmp = new Rectangle(union.x, union.y - 1, union.width, maxtop - union.y + 2);
                    control.repaint(tmp);
                }
                if (this.bounds.y + this.bounds.height != oldBounds.y + oldBounds.height) {
                    int minbottom = Math.min(this.bounds.y + this.bounds.height, oldBounds.y + oldBounds.height);
                    tmp = new Rectangle(union.x, minbottom - 1, union.width, union.y + union.height - minbottom + 1);
                    control.repaint(tmp);
                }
                if (!this.graphComponent.isToggleEvent(e) && !this.graphComponent.getGraph().isSelectionEmpty()) {
                    this.graphComponent.getGraph().clearSelection();
                }
            }
            e.consume();
        }
    }

    public void mouseReleased(MouseEvent e) {
        Rectangle rect = this.bounds;
        this.reset();
        if (!e.isConsumed() && rect != null && this.graphComponent.isSignificant(rect.width, rect.height)) {
            this.select(rect, e);
            e.consume();
        }
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent arg0) {
    }
}

