/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.net.server;

import com.github.xingshuangs.iot.exceptions.SocketRuntimeException;
import com.github.xingshuangs.iot.net.SocketUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerBasic {
    private static final Logger log = LoggerFactory.getLogger(TcpServerBasic.class);
    private ServerSocket serverSocket;
    protected int port = 8088;

    public void start() {
        this.start(this.port);
    }

    public void start(int port) {
        try {
            this.port = port;
            this.stop();
            this.serverSocket = new ServerSocket(port);
            Thread thread = new Thread(this::waitForClients);
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.isAlive()) {
                this.serverSocket.close();
                log.debug("\u5173\u95ed\u670d\u52a1\u7aef\uff0c\u7aef\u53e3\u53f7[{}]", (Object)this.port);
            }
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    public boolean isAlive() {
        return this.serverSocket != null && !this.serverSocket.isClosed();
    }

    protected void waitForClients() {
        log.debug("\u5f00\u542f\u7b49\u5f85\u5ba2\u6237\u7aef\u7ebf\u7a0b\uff0c\u7aef\u53e3\u53f7[{}]", (Object)this.port);
        while (this.isAlive()) {
            try {
                Socket client = this.serverSocket.accept();
                if (!this.checkClientValid(client)) {
                    SocketUtils.close(client);
                }
                Thread thread = new Thread(() -> this.doClientConnected(client));
                thread.setDaemon(true);
                thread.start();
            }
            catch (IOException e) {
                if (!this.isAlive()) continue;
                log.error(e.getMessage());
            }
        }
    }

    protected boolean checkClientValid(Socket client) throws IOException {
        return true;
    }

    protected void doClientConnected(Socket client) {
        log.debug("\u6709\u5ba2\u6237\u7aef[{}]\u8fde\u5165", (Object)client.getRemoteSocketAddress());
        this.clientConnected(client);
        try {
            if (this.checkHandshake(client)) {
                while (SocketUtils.isConnected(client)) {
                    this.doClientHandle(client);
                }
            }
        }
        catch (Exception e) {
            if (SocketUtils.isConnected(client)) {
                log.error(e.getMessage());
            }
        }
        finally {
            try {
                SocketUtils.close(client);
            }
            catch (Exception exception) {}
        }
        this.clientDisconnected(client);
        log.debug("\u6709\u5ba2\u6237\u7aef[{}]\u65ad\u5f00", (Object)client.getRemoteSocketAddress());
    }

    protected void clientConnected(Socket socket) {
    }

    protected void clientDisconnected(Socket socket) {
    }

    protected boolean checkHandshake(Socket socket) {
        return true;
    }

    protected void doClientHandle(Socket socket) {
        byte[] data = this.readClientData(socket);
        log.debug(new String(data));
    }

    protected byte[] readClientData(Socket socket) {
        try {
            InputStream in = socket.getInputStream();
            int firstByte = in.read();
            if (firstByte == -1) {
                SocketUtils.close(socket);
                throw new SocketRuntimeException("\u5ba2\u6237\u7aef\u4e3b\u52a8\u65ad\u5f00");
            }
            byte[] data = new byte[in.available() + 1];
            data[0] = (byte)firstByte;
            this.read(socket, data, 1, data.length - 1, 1024);
            return data;
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    protected void write(Socket socket, byte[] data) {
        try {
            SocketUtils.write(socket, data);
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    protected int read(Socket socket, byte[] data) {
        return this.read(socket, data, 0, data.length, 1024);
    }

    private int read(Socket socket, byte[] data, int offset, int length) {
        return this.read(socket, data, offset, length, 1024);
    }

    protected int read(Socket socket, byte[] data, int offset, int length, int maxLength) {
        try {
            return SocketUtils.read(socket, data, offset, length, maxLength);
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }
}

