/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.parse.hex;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DataUnit<T> {
    private String name = "";
    private String description = "";
    private String unit = "";
    private byte[] bytes = new byte[0];
    private T value;
    private int byteOffset = 0;
    private int bitOffset = 0;
    private int count = 1;
    private DataTypeEm dataType = DataTypeEm.STRING;
    private boolean littleEndian = false;

    public DataUnit() {
    }

    public DataUnit(int byteOffset, String dataType) {
        this.byteOffset = byteOffset;
        this.dataType = DataTypeEm.valueFrom(dataType);
    }

    public DataUnit(int byteOffset, int count, String dataType) {
        this.byteOffset = byteOffset;
        this.count = count;
        this.dataType = DataTypeEm.valueFrom(dataType);
    }

    public DataUnit(int byteOffset, int bitOffset, int count, String dataType) {
        this.byteOffset = byteOffset;
        this.bitOffset = bitOffset;
        this.count = count;
        this.dataType = DataTypeEm.valueFrom(dataType);
    }

    public DataUnit(int byteOffset, int bitOffset, int count, String dataType, String name) {
        this.byteOffset = byteOffset;
        this.bitOffset = bitOffset;
        this.count = count;
        this.dataType = DataTypeEm.valueFrom(dataType);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(int byteOffset) {
        this.byteOffset = byteOffset;
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public void setBitOffset(int bitOffset) {
        this.bitOffset = bitOffset;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public DataTypeEm getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypeEm dataType) {
        this.dataType = dataType;
    }

    public boolean getLittleEndian() {
        return this.littleEndian;
    }

    public void setLittleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataUnit)) {
            return false;
        }
        DataUnit dataUnit = (DataUnit)o;
        return this.getByteOffset() == dataUnit.getByteOffset() && this.getBitOffset() == dataUnit.getBitOffset() && this.getCount() == dataUnit.getCount() && this.getLittleEndian() == dataUnit.getLittleEndian() && Objects.equals(this.getName(), dataUnit.getName()) && Objects.equals(this.getDescription(), dataUnit.getDescription()) && Objects.equals(this.getUnit(), dataUnit.getUnit()) && Arrays.equals(this.getBytes(), dataUnit.getBytes()) && Objects.equals(this.getValue(), dataUnit.getValue()) && this.getDataType() == dataUnit.getDataType();
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.getName(), this.getDescription(), this.getUnit(), this.getValue(), this.getByteOffset(), this.getBitOffset(), this.getCount(), this.getDataType(), this.getLittleEndian()});
        result = 31 * result + Arrays.hashCode(this.getBytes());
        return result;
    }

    public String toString() {
        return "DataUnit{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", unit='" + this.unit + '\'' + ", bytes=" + Arrays.toString(this.bytes) + ", value=" + this.value + ", byteOffset=" + this.byteOffset + ", bitOffset=" + this.bitOffset + ", count=" + this.count + ", dataType='" + (Object)((Object)this.dataType) + '\'' + ", littleEndian=" + this.littleEndian + '}';
    }

    public Integer getTotalByteLength() {
        switch (this.dataType) {
            case BOOL: {
                return (this.bitOffset + this.count) % 8 == 0 ? (this.bitOffset + this.count) / 8 : (this.bitOffset + this.count) / 8 + 1;
            }
            case INT8: {
                return this.count;
            }
            case UINT8: {
                return this.count;
            }
            case INT16: {
                return this.count * 2;
            }
            case UINT16: {
                return this.count * 2;
            }
            case INT32: {
                return this.count * 4;
            }
            case UINT32: {
                return this.count * 4;
            }
            case FLOAT32: {
                return this.count * 4;
            }
            case FLOAT64: {
                return this.count * 8;
            }
            case STRING: {
                return this.count;
            }
        }
        return this.count;
    }

    public static enum DataTypeEm {
        BOOL("bool"),
        INT8("byte"),
        UINT8("ubyte"),
        INT16("short"),
        UINT16("ushort"),
        INT32("int"),
        UINT32("uint"),
        FLOAT32("float"),
        FLOAT64("double"),
        STRING("string");

        private static final Map<String, DataTypeEm> VALUES;
        String value;

        private DataTypeEm(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static DataTypeEm valueFrom(String type) {
            if (type.length() <= 0 || !VALUES.containsKey(type)) {
                throw new IllegalArgumentException("unknown data type: " + type);
            }
            return VALUES.get(type);
        }

        static {
            DataTypeEm[] values = DataTypeEm.values();
            VALUES = new HashMap<String, DataTypeEm>();
            for (DataTypeEm item : values) {
                String value = item.value;
                if (VALUES.containsKey(value)) {
                    throw new AssertionError((Object)("value already in use: " + value));
                }
                VALUES.put(value, item);
            }
        }
    }
}

