/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.parse.hex;

import com.github.xingshuangs.iot.exceptions.HexParseException;
import com.github.xingshuangs.iot.parse.hex.DataUnit;
import com.github.xingshuangs.iot.utils.FloatUtil;
import com.github.xingshuangs.iot.utils.IntegerUtil;
import com.github.xingshuangs.iot.utils.ShortUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class HexParse {
    private byte[] rdSrc;

    public HexParse() {
        this(new byte[0]);
    }

    public HexParse(byte[] rdSrc) {
        this.rdSrc = rdSrc;
    }

    private <T> List<T> toHandle(int byteOffset, int count, double typeByteLength, Function<Integer, T> fun) {
        if (byteOffset < 0 || byteOffset >= this.rdSrc.length) {
            throw new HexParseException(String.format("\u5b57\u8282\u504f\u79fb\u91cf[%d] \u8d85\u8fc7 \u603b\u6570\u636e\u957f\u5ea6[%d]", byteOffset, this.rdSrc.length));
        }
        if (count < 1) {
            throw new HexParseException(String.format("\u83b7\u53d6\u7684\u6570\u636e\u4e2a\u6570[%d] < 1", count));
        }
        if ((double)byteOffset + (double)count * typeByteLength > (double)this.rdSrc.length) {
            throw new HexParseException(String.format("\u5b57\u8282\u504f\u79fb\u91cf[%d] + \u6570\u636e\u4e2a\u6570[%d] * \u7c7b\u578b\u5b57\u8282\u957f\u5ea6[%f] > \u603b\u6570\u636e\u5b57\u8282\u957f\u5ea6[%d]", byteOffset, count, typeByteLength, this.rdSrc.length));
        }
        ArrayList<T> res = new ArrayList<T>();
        for (int i = 0; i < count; ++i) {
            res.add(fun.apply(i));
        }
        return res;
    }

    public Boolean toBoolean(int byteOffset, int bitOffset) {
        return this.toBoolean(byteOffset, bitOffset, 1).get(0);
    }

    public List<Boolean> toBoolean(int byteOffset, int bitOffset, int count) {
        if (bitOffset < 0 || bitOffset > 7) {
            throw new HexParseException("bitOffset\u4f4d\u504f\u79fb\u91cf\u8303\u56f4[0,7]");
        }
        return this.toHandle(byteOffset, count, 0.125, i -> {
            int bitAdd = (bitOffset + i) % 8;
            int byteAdd = byteOffset + (bitOffset + i) / 8;
            return ((this.rdSrc[byteAdd] & 0xFF) >> bitAdd & 1) == 1;
        });
    }

    public Byte toInt8(int byteOffset) {
        return this.toInt8(byteOffset, 1).get(0);
    }

    public List<Byte> toInt8(int byteOffset, int count) {
        return this.toHandle(byteOffset, count, 1.0, i -> this.rdSrc[byteOffset + i]);
    }

    public Integer toUInt8(int byteOffset) {
        return this.toUInt8(byteOffset, 1).get(0);
    }

    public List<Integer> toUInt8(int byteOffset, int count) {
        return this.toHandle(byteOffset, count, 1.0, i -> this.rdSrc[byteOffset + i] & 0xFF);
    }

    public Short toInt16(int byteOffset) {
        return this.toInt16(byteOffset, 1, false).get(0);
    }

    public List<Short> toInt16(int byteOffset, int count, boolean littleEndian) {
        int typeByteLength = 2;
        return this.toHandle(byteOffset, count, typeByteLength, i -> ShortUtil.toInt16(this.rdSrc, byteOffset + i * typeByteLength, littleEndian));
    }

    public Integer toUInt16(int byteOffset) {
        return this.toUInt16(byteOffset, 1, false).get(0);
    }

    public List<Integer> toUInt16(int byteOffset, int count, boolean littleEndian) {
        int typeByteLength = 2;
        return this.toHandle(byteOffset, count, typeByteLength, i -> ShortUtil.toUInt16(this.rdSrc, byteOffset + i * typeByteLength, littleEndian));
    }

    public Integer toInt32(int byteOffset) {
        return this.toInt32(byteOffset, 1, false).get(0);
    }

    public List<Integer> toInt32(int byteOffset, int count, boolean littleEndian) {
        int typeByteLength = 4;
        return this.toHandle(byteOffset, count, typeByteLength, i -> IntegerUtil.toInt32(this.rdSrc, byteOffset + i * typeByteLength, littleEndian));
    }

    public Long toUInt32(int byteOffset) {
        return this.toUInt32(byteOffset, 1, false).get(0);
    }

    public List<Long> toUInt32(int byteOffset, int count, boolean littleEndian) {
        int typeByteLength = 4;
        return this.toHandle(byteOffset, count, typeByteLength, i -> IntegerUtil.toUInt32(this.rdSrc, byteOffset + i * typeByteLength, littleEndian));
    }

    public Float toFloat32(int byteOffset) {
        return this.toFloat32(byteOffset, 1, false).get(0);
    }

    public List<Float> toFloat32(int byteOffset, int count, boolean littleEndian) {
        int typeByteLength = 4;
        return this.toHandle(byteOffset, count, typeByteLength, i -> Float.valueOf(FloatUtil.toFloat32(this.rdSrc, byteOffset + i * typeByteLength, littleEndian)));
    }

    public Double toFloat64(int byteOffset) {
        return this.toFloat64(byteOffset, 1, false).get(0);
    }

    public List<Double> toFloat64(int byteOffset, int count, boolean littleEndian) {
        int typeByteLength = 8;
        return this.toHandle(byteOffset, count, typeByteLength, i -> FloatUtil.toFloat64(this.rdSrc, byteOffset + i * typeByteLength, littleEndian));
    }

    public String toStringUtf8(int byteOffset, int count) {
        int typeByteLength = 1;
        if (byteOffset < 0 || byteOffset >= this.rdSrc.length) {
            throw new HexParseException(String.format("\u5b57\u8282\u504f\u79fb\u91cf[%d] \u8d85\u8fc7 \u603b\u6570\u636e\u957f\u5ea6[%d]", byteOffset, this.rdSrc.length));
        }
        if (count < 1) {
            throw new HexParseException(String.format("\u83b7\u53d6\u7684\u6570\u636e\u4e2a\u6570[%d] < 1", count));
        }
        if (byteOffset + count * typeByteLength > this.rdSrc.length) {
            throw new HexParseException(String.format("\u5b57\u8282\u504f\u79fb\u91cf[%d] + \u6570\u636e\u4e2a\u6570[%d] * \u7c7b\u578b\u5b57\u8282\u957f\u5ea6[%f] > \u603b\u6570\u636e\u5b57\u8282\u957f\u5ea6[%d]", byteOffset, count, typeByteLength, this.rdSrc.length));
        }
        byte[] bs = new byte[count];
        System.arraycopy(this.rdSrc, byteOffset, bs, 0, count);
        return new String(bs, StandardCharsets.UTF_8);
    }

    public void parseData(DataUnit unit) {
        switch (unit.getDataType()) {
            case BOOL: {
                if (unit.getCount() == 1) {
                    unit.setValue(this.toBoolean(unit.getByteOffset(), unit.getBitOffset()));
                    break;
                }
                unit.setValue(this.toBoolean(unit.getByteOffset(), unit.getBitOffset(), unit.getCount()));
                break;
            }
            case INT8: {
                if (unit.getCount() == 1) {
                    unit.setValue(this.toInt8(unit.getByteOffset()));
                    break;
                }
                unit.setValue(this.toInt8(unit.getByteOffset(), unit.getCount()));
                break;
            }
            case UINT8: {
                if (unit.getCount() == 1) {
                    unit.setValue(this.toUInt8(unit.getByteOffset()));
                    break;
                }
                unit.setValue(this.toUInt8(unit.getByteOffset(), unit.getCount()));
                break;
            }
            case INT16: {
                if (unit.getCount() == 1) {
                    unit.setValue(this.toInt16(unit.getByteOffset()));
                    break;
                }
                unit.setValue(this.toInt16(unit.getByteOffset(), unit.getCount(), unit.getLittleEndian()));
                break;
            }
            case UINT16: {
                if (unit.getCount() == 1) {
                    unit.setValue(this.toUInt16(unit.getByteOffset()));
                    break;
                }
                unit.setValue(this.toUInt16(unit.getByteOffset(), unit.getCount(), unit.getLittleEndian()));
                break;
            }
            case INT32: {
                if (unit.getCount() == 1) {
                    unit.setValue(this.toInt32(unit.getByteOffset()));
                    break;
                }
                unit.setValue(this.toInt32(unit.getByteOffset(), unit.getCount(), unit.getLittleEndian()));
                break;
            }
            case UINT32: {
                if (unit.getCount() == 1) {
                    unit.setValue(this.toUInt32(unit.getByteOffset()));
                    break;
                }
                unit.setValue(this.toUInt32(unit.getByteOffset(), unit.getCount(), unit.getLittleEndian()));
                break;
            }
            case FLOAT32: {
                if (unit.getCount() == 1) {
                    unit.setValue(this.toFloat32(unit.getByteOffset()));
                    break;
                }
                unit.setValue(this.toFloat32(unit.getByteOffset(), unit.getCount(), unit.getLittleEndian()));
                break;
            }
            case FLOAT64: {
                if (unit.getCount() == 1) {
                    unit.setValue(this.toFloat64(unit.getByteOffset()));
                    break;
                }
                unit.setValue(this.toFloat64(unit.getByteOffset(), unit.getCount(), unit.getLittleEndian()));
                break;
            }
            case STRING: {
                unit.setValue(this.toStringUtf8(unit.getByteOffset(), unit.getCount()));
                break;
            }
            default: {
                throw new HexParseException("\u65e0\u6cd5\u89e3\u6790\u6570\u636e\uff0c\u6570\u636e\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
        }
    }

    public void parseDataList(List<DataUnit> list) {
        list.forEach(this::parseData);
    }
}

