/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.protocol.common.IObjectByteArray;
import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import java.util.concurrent.atomic.AtomicInteger;

public class MbapHeader
implements IObjectByteArray {
    private static final AtomicInteger index = new AtomicInteger();
    public static final int BYTE_LENGTH = 7;
    private int transactionId;
    private int protocolId = 0;
    private int length = 0;
    private int unitId = 0;

    public MbapHeader() {
    }

    public MbapHeader(int transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public int byteArrayLength() {
        return 7;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(7).putShort(this.transactionId).putShort(this.protocolId).putShort(this.length).putByte(this.unitId).getData();
    }

    public static int getNewNumber() {
        int res = index.getAndIncrement();
        if (res >= 65536) {
            index.set(0);
            res = 0;
        }
        return res;
    }

    public static MbapHeader fromBytes(byte[] data) {
        return MbapHeader.fromBytes(data, 0);
    }

    public static MbapHeader fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbapHeader res = new MbapHeader();
        res.transactionId = buff.getUInt16();
        res.protocolId = buff.getUInt16();
        res.length = buff.getUInt16();
        res.unitId = buff.getByteToInt();
        return res;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public int getLength() {
        return this.length;
    }

    public int getUnitId() {
        return this.unitId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public void setProtocolId(int protocolId) {
        this.protocolId = protocolId;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setUnitId(int unitId) {
        this.unitId = unitId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbapHeader)) {
            return false;
        }
        MbapHeader other = (MbapHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        if (this.getProtocolId() != other.getProtocolId()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        return this.getUnitId() == other.getUnitId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MbapHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        result = result * 59 + this.getProtocolId();
        result = result * 59 + this.getLength();
        result = result * 59 + this.getUnitId();
        return result;
    }

    public String toString() {
        return "MbapHeader(transactionId=" + this.getTransactionId() + ", protocolId=" + this.getProtocolId() + ", length=" + this.getLength() + ", unitId=" + this.getUnitId() + ")";
    }
}

