/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;

public class Mp4AvcCBox
extends Mp4Box {
    private final int version;
    private final int profile;
    private final int profileCompat;
    private final int level;
    private final int lengthSizeMinusOne;
    private final int spsCount;
    private final int spsLength;
    private final byte[] sps;
    private final int ppsCount;
    private final int ppsLength;
    private final byte[] pps;

    public Mp4AvcCBox(Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.AVCC;
        this.version = 1;
        this.profile = trackInfo.getSps()[1];
        this.profileCompat = trackInfo.getSps()[2];
        this.level = trackInfo.getSps()[3];
        this.lengthSizeMinusOne = 255;
        this.spsCount = 225;
        this.spsLength = trackInfo.getSps().length;
        this.sps = trackInfo.getSps();
        this.ppsCount = 1;
        this.ppsLength = trackInfo.getPps().length;
        this.pps = trackInfo.getPps();
    }

    @Override
    public int byteArrayLength() {
        return 19 + this.spsLength + this.ppsLength;
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putByte(this.version).putByte(this.profile).putByte(this.profileCompat).putByte(this.level).putByte(this.lengthSizeMinusOne).putByte(this.spsCount).putShort(this.spsLength).putBytes(this.sps).putByte(this.ppsCount).putShort(this.ppsLength).putBytes(this.pps).getData();
    }
}

