/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;
import com.github.xingshuangs.iot.utils.TimesUtil;
import java.time.LocalDateTime;

public class Mp4MvhdBox
extends Mp4Box {
    private final int version;
    private final byte[] flags;
    private final LocalDateTime creationTime;
    private final LocalDateTime modificationTime;
    private final int timescale;
    private final int duration;
    private final int rate;
    private final int volume;
    private final byte[] reserved;
    private final byte[] videoTransformationMatrix;
    private final byte[] preDefined;
    private final int nextTrackId;

    public Mp4MvhdBox(Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.MVHD;
        this.version = 0;
        this.flags = new byte[3];
        this.creationTime = TimesUtil.getUTCDateTime(1L);
        this.modificationTime = TimesUtil.getUTCDateTime(2L);
        this.timescale = trackInfo.getTimescale();
        this.duration = trackInfo.getDuration();
        this.rate = 1;
        this.volume = 1;
        this.reserved = new byte[10];
        this.videoTransformationMatrix = new byte[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0};
        this.preDefined = new byte[24];
        this.nextTrackId = -1;
    }

    @Override
    public int byteArrayLength() {
        return 108;
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putByte(this.version).putBytes(this.flags).putInteger(TimesUtil.getUTCTotalSecond(this.creationTime)).putInteger(TimesUtil.getUTCTotalSecond(this.modificationTime)).putInteger(this.timescale).putInteger(this.duration).putInteger(this.rate << 16).putShort(this.volume << 8).putBytes(this.reserved).putBytes(this.videoTransformationMatrix).putBytes(this.preDefined).putInteger(this.nextTrackId).getData();
    }
}

