/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4MdiaBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TkhdBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;

public class Mp4TrakBox
extends Mp4Box {
    private final Mp4TkhdBox tkhdBox;
    private final Mp4MdiaBox mdiaBox;

    public Mp4TrakBox(Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.TRAK;
        this.tkhdBox = new Mp4TkhdBox(trackInfo);
        this.mdiaBox = new Mp4MdiaBox(trackInfo);
    }

    @Override
    public int byteArrayLength() {
        return 8 + this.tkhdBox.byteArrayLength() + this.mdiaBox.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putBytes(this.tkhdBox.toByteArray()).putBytes(this.mdiaBox.toByteArray()).getData();
    }
}

