/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtcp.enums.ERtcpPackageType;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpBasePackage;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpHeader;

public final class RtcpBye
extends RtcpBasePackage {
    private long sourceId;

    public RtcpBye() {
    }

    public RtcpBye(long sourceId) {
        this.header = new RtcpHeader();
        this.header.version = 2;
        this.header.padding = false;
        this.header.receptionCount = 1;
        this.header.packageType = ERtcpPackageType.BYE;
        this.header.length = 1;
        this.sourceId = sourceId;
    }

    @Override
    public int byteArrayLength() {
        return 8;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(8).putBytes(this.header.toByteArray()).putInteger(this.sourceId).getData();
    }

    public static RtcpBye fromBytes(byte[] data) {
        return RtcpBye.fromBytes(data, 0);
    }

    public static RtcpBye fromBytes(byte[] data, int offset) {
        if (data.length < 8) {
            throw new IndexOutOfBoundsException("\u89e3\u6790RtcpBye\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        RtcpBye res = new RtcpBye();
        res.header = RtcpHeader.fromBytes(data, offset);
        ByteReadBuff buff = new ByteReadBuff(data, offset + res.header.byteArrayLength());
        res.sourceId = buff.getUInt32();
        return res;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(long sourceId) {
        this.sourceId = sourceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtcpBye)) {
            return false;
        }
        RtcpBye other = (RtcpBye)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getSourceId() == other.getSourceId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtcpBye;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sourceId = this.getSourceId();
        result = result * 59 + (int)($sourceId >>> 32 ^ $sourceId);
        return result;
    }

    public String toString() {
        return "RtcpBye(sourceId=" + this.getSourceId() + ")";
    }
}

