/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBase;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluFuHeader;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import com.github.xingshuangs.iot.utils.ShortUtil;
import java.util.Arrays;

public class H264NaluFuB
extends H264NaluBase {
    private H264NaluFuHeader fuHeader = new H264NaluFuHeader();
    private int decodingOrderNumber;
    protected byte[] payload = new byte[0];

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + this.fuHeader.byteArrayLength() + 2 + this.payload.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putBytes(this.header.toByteArray()).putBytes(this.fuHeader.toByteArray()).putShort(this.decodingOrderNumber).putBytes(this.payload).getData();
    }

    public static H264NaluFuB fromBytes(byte[] data) {
        return H264NaluFuB.fromBytes(data, 0);
    }

    public static H264NaluFuB fromBytes(byte[] data, int offset) {
        if (data.length < 1) {
            throw new IndexOutOfBoundsException("\u89e3\u6790H264NaluSingle\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        H264NaluFuB res = new H264NaluFuB();
        int index = offset;
        res.header = H264NaluHeader.fromBytes(data, index);
        res.decodingOrderNumber = ShortUtil.toUInt16(data, index += res.header.byteArrayLength());
        res.fuHeader = H264NaluFuHeader.fromBytes(data, index += 2);
        ByteReadBuff buff = new ByteReadBuff(data, index += res.fuHeader.byteArrayLength());
        res.payload = buff.getBytes();
        return res;
    }

    public H264NaluFuHeader getFuHeader() {
        return this.fuHeader;
    }

    public int getDecodingOrderNumber() {
        return this.decodingOrderNumber;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setFuHeader(H264NaluFuHeader fuHeader) {
        this.fuHeader = fuHeader;
    }

    public void setDecodingOrderNumber(int decodingOrderNumber) {
        this.decodingOrderNumber = decodingOrderNumber;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H264NaluFuB)) {
            return false;
        }
        H264NaluFuB other = (H264NaluFuB)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDecodingOrderNumber() != other.getDecodingOrderNumber()) {
            return false;
        }
        H264NaluFuHeader this$fuHeader = this.getFuHeader();
        H264NaluFuHeader other$fuHeader = other.getFuHeader();
        if (this$fuHeader == null ? other$fuHeader != null : !((Object)this$fuHeader).equals(other$fuHeader)) {
            return false;
        }
        return Arrays.equals(this.getPayload(), other.getPayload());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof H264NaluFuB;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDecodingOrderNumber();
        H264NaluFuHeader $fuHeader = this.getFuHeader();
        result = result * 59 + ($fuHeader == null ? 43 : ((Object)$fuHeader).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayload());
        return result;
    }

    @Override
    public String toString() {
        return "H264NaluFuB(fuHeader=" + this.getFuHeader() + ", decodingOrderNumber=" + this.getDecodingOrderNumber() + ", payload=" + Arrays.toString(this.getPayload()) + ")";
    }
}

