/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBase;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluMtap24Single;
import java.util.ArrayList;
import java.util.List;

public class H264NaluMtap24
extends H264NaluBase {
    private int decodingOrderNumber;
    private List<H264NaluMtap24Single> naluSingles = new ArrayList<H264NaluMtap24Single>();

    @Override
    public int byteArrayLength() {
        int sum = this.header.byteArrayLength();
        sum += 2;
        for (H264NaluMtap24Single item : this.naluSingles) {
            sum += item.byteArrayLength();
        }
        return sum;
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength());
        buff.putBytes(this.header.toByteArray());
        buff.putShort(this.decodingOrderNumber);
        for (H264NaluMtap24Single item : this.naluSingles) {
            buff.putBytes(item.toByteArray());
        }
        return buff.getData();
    }

    public static H264NaluMtap24 fromBytes(byte[] data) {
        return H264NaluMtap24.fromBytes(data, 0);
    }

    public static H264NaluMtap24 fromBytes(byte[] data, int offset) {
        if (data.length < 3) {
            throw new IndexOutOfBoundsException("\u89e3\u6790H264NaluStapSingle\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        int index = offset;
        H264NaluMtap24 res = new H264NaluMtap24();
        res.header = H264NaluHeader.fromBytes(data, index);
        res.decodingOrderNumber = ByteReadBuff.newInstance(data, index += res.header.byteArrayLength()).getUInt16();
        index += 2;
        while (index < data.length) {
            H264NaluMtap24Single tmp = H264NaluMtap24Single.fromBytes(data, index);
            res.naluSingles.add(tmp);
            index += tmp.byteArrayLength();
        }
        return res;
    }
}

