/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluSingle;
import com.github.xingshuangs.iot.utils.IntegerUtil;

public class H264NaluMtap24Single
extends H264NaluSingle {
    private int size;
    private int dond;
    private int tsOffset;

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + 2 + this.payload.length;
    }

    @Override
    public byte[] toByteArray() {
        byte[] tsOffsetBytes = IntegerUtil.toCustomByteArray(this.tsOffset, 1, 3);
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putShort(this.size).putByte(this.dond).putBytes(tsOffsetBytes).putBytes(this.header.toByteArray()).putBytes(this.payload).getData();
    }

    public static H264NaluMtap24Single fromBytes(byte[] data) {
        return H264NaluMtap24Single.fromBytes(data, 0);
    }

    public static H264NaluMtap24Single fromBytes(byte[] data, int offset) {
        if (data.length < 3) {
            throw new IndexOutOfBoundsException("\u89e3\u6790H264NaluStapSingle\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        int index = offset;
        ByteReadBuff buff = ByteReadBuff.newInstance(data, index);
        H264NaluMtap24Single res = new H264NaluMtap24Single();
        res.size = buff.getUInt16();
        res.dond = buff.getByteToInt();
        res.tsOffset = IntegerUtil.toInt32In3Bytes(buff.getBytes(3), 0);
        res.header = H264NaluHeader.fromBytes(data, index += 6);
        res.payload = ByteReadBuff.newInstance(data, index += res.header.byteArrayLength()).getBytes(res.size);
        return res;
    }
}

