/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBase;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import java.util.Arrays;

public class H264NaluSingle
extends H264NaluBase {
    protected byte[] payload;

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + this.payload.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putBytes(this.header.toByteArray()).putBytes(this.payload).getData();
    }

    public static H264NaluSingle fromBytes(byte[] data) {
        return H264NaluSingle.fromBytes(data, 0);
    }

    public static H264NaluSingle fromBytes(byte[] data, int offset) {
        if (data.length < 1) {
            throw new IndexOutOfBoundsException("\u89e3\u6790H264NaluSingle\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        H264NaluSingle res = new H264NaluSingle();
        int index = offset;
        res.header = H264NaluHeader.fromBytes(data, index);
        ByteReadBuff buff = new ByteReadBuff(data, index += res.header.byteArrayLength());
        res.payload = buff.getBytes();
        return res;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H264NaluSingle)) {
            return false;
        }
        H264NaluSingle other = (H264NaluSingle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getPayload(), other.getPayload());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof H264NaluSingle;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getPayload());
        return result;
    }

    @Override
    public String toString() {
        return "H264NaluSingle(payload=" + Arrays.toString(this.getPayload()) + ")";
    }
}

