/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model;

import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspMethod;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RtspOptionResponse
extends RtspMessageResponse {
    private List<ERtspMethod> publicMethods = new ArrayList<ERtspMethod>();

    public static RtspOptionResponse fromHeaderString(String src) {
        if (src == null || src.equals("")) {
            throw new RtspCommException("\u89e3\u6790RtspOptionResponse\u65f6\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        }
        RtspOptionResponse response = new RtspOptionResponse();
        Map<String, String> map = response.parseHeaderAndReturnMap(src);
        if (map.containsKey("Public")) {
            String publicStr = map.get("Public").trim();
            response.publicMethods = Stream.of(publicStr.split(",")).map(x -> ERtspMethod.from(x.trim())).collect(Collectors.toList());
        }
        return response;
    }

    @Override
    protected void addResponseHeader(StringBuilder sb) {
        if (!this.publicMethods.isEmpty()) {
            String str = this.publicMethods.stream().map(ERtspMethod::getCode).collect(Collectors.joining(","));
            sb.append("Public").append(": ").append(str).append("\r\n");
        }
    }

    public List<ERtspMethod> getPublicMethods() {
        return this.publicMethods;
    }
}

