/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.base;

import com.github.xingshuangs.iot.utils.StringSpUtil;
import java.util.Map;

public class RtspRtpInfo {
    private String url;
    private Long seq;
    private Long rtpTime;

    public static RtspRtpInfo fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("RtspRtpInfo\u90e8\u5206\u6570\u636e\u89e3\u6790\u9519\u8bef");
        }
        Map<String, String> map = StringSpUtil.splitTwoStepByLine(src, ";", "=");
        RtspRtpInfo rtpInfo = new RtspRtpInfo();
        rtpInfo.url = map.getOrDefault("url", "");
        if (map.containsKey("seq")) {
            rtpInfo.seq = Long.parseLong(map.get("seq"));
        }
        if (map.containsKey("rtptime")) {
            rtpInfo.rtpTime = Long.parseLong(map.get("rtptime"));
        }
        return rtpInfo;
    }

    public String getUrl() {
        return this.url;
    }

    public Long getSeq() {
        return this.seq;
    }

    public Long getRtpTime() {
        return this.rtpTime;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSeq(Long seq) {
        this.seq = seq;
    }

    public void setRtpTime(Long rtpTime) {
        this.rtpTime = rtpTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspRtpInfo)) {
            return false;
        }
        RtspRtpInfo other = (RtspRtpInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$seq = this.getSeq();
        Long other$seq = other.getSeq();
        if (this$seq == null ? other$seq != null : !((Object)this$seq).equals(other$seq)) {
            return false;
        }
        Long this$rtpTime = this.getRtpTime();
        Long other$rtpTime = other.getRtpTime();
        if (this$rtpTime == null ? other$rtpTime != null : !((Object)this$rtpTime).equals(other$rtpTime)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspRtpInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $seq = this.getSeq();
        result = result * 59 + ($seq == null ? 43 : ((Object)$seq).hashCode());
        Long $rtpTime = this.getRtpTime();
        result = result * 59 + ($rtpTime == null ? 43 : ((Object)$rtpTime).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public String toString() {
        return "RtspRtpInfo(url=" + this.getUrl() + ", seq=" + this.getSeq() + ", rtpTime=" + this.getRtpTime() + ")";
    }
}

