/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.sdp;

import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpBandwidth;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpConnection;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpEncryptKey;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpMediaDesc;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.attribute.RtspSdpMediaAttrControl;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.attribute.RtspSdpMediaAttrDimension;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.attribute.RtspSdpMediaAttrFmtp;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.attribute.RtspSdpMediaAttrHeader;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.attribute.RtspSdpMediaAttrRtpMap;
import com.github.xingshuangs.iot.utils.StringSpUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RtspSdpMedia {
    private RtspSdpMediaDesc mediaDesc;
    private RtspSdpConnection connection;
    private RtspSdpBandwidth bandwidth;
    private RtspSdpEncryptKey encryptKey;
    private Map<String, String> attributes = new HashMap<String, String>();

    public static RtspSdpMedia fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("SDP\u89e3\u6790media\u90e8\u5206\u6570\u636e\u6e90\u9519\u8bef");
        }
        RtspSdpMedia media = new RtspSdpMedia();
        List<String> list = StringSpUtil.splitOneStepByLine(src, "\r\n");
        for (String item : list) {
            int i = item.indexOf("=");
            if (i == -1) continue;
            String key = item.substring(0, i).trim();
            String value = item.substring(i + 1).trim();
            switch (key) {
                case "m": {
                    media.mediaDesc = RtspSdpMediaDesc.fromString(value);
                    break;
                }
                case "c": {
                    media.connection = RtspSdpConnection.fromString(value);
                    break;
                }
                case "b": {
                    media.bandwidth = RtspSdpBandwidth.fromString(value);
                    break;
                }
                case "a": {
                    int index = value.indexOf(":");
                    if (index == -1) {
                        media.attributes.put(value, "");
                        break;
                    }
                    media.attributes.put(value.substring(0, index), value.substring(index + 1));
                    break;
                }
            }
        }
        return media;
    }

    public RtspSdpMediaAttrControl getAttributeControl() {
        String value = this.attributes.get("control");
        if (value == null) {
            return null;
        }
        return RtspSdpMediaAttrControl.fromString(value);
    }

    public RtspSdpMediaAttrDimension getAttributeDimension() {
        String value = this.attributes.get("x-dimensions");
        if (value == null) {
            return null;
        }
        return RtspSdpMediaAttrDimension.fromString(value);
    }

    public RtspSdpMediaAttrFmtp getAttributeFmtp() {
        String value = this.attributes.get("fmtp");
        if (value == null) {
            return null;
        }
        return RtspSdpMediaAttrFmtp.fromString(value);
    }

    public RtspSdpMediaAttrRtpMap getAttributeRtpMap() {
        String value = this.attributes.get("rtpmap");
        if (value == null) {
            return null;
        }
        return RtspSdpMediaAttrRtpMap.fromString(value);
    }

    public RtspSdpMediaAttrHeader getAttributeHeader() {
        String value = this.attributes.get("Media_header");
        if (value == null) {
            return null;
        }
        return RtspSdpMediaAttrHeader.fromString(value);
    }

    public RtspSdpMediaDesc getMediaDesc() {
        return this.mediaDesc;
    }

    public RtspSdpConnection getConnection() {
        return this.connection;
    }

    public RtspSdpBandwidth getBandwidth() {
        return this.bandwidth;
    }

    public RtspSdpEncryptKey getEncryptKey() {
        return this.encryptKey;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setMediaDesc(RtspSdpMediaDesc mediaDesc) {
        this.mediaDesc = mediaDesc;
    }

    public void setConnection(RtspSdpConnection connection) {
        this.connection = connection;
    }

    public void setBandwidth(RtspSdpBandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    public void setEncryptKey(RtspSdpEncryptKey encryptKey) {
        this.encryptKey = encryptKey;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspSdpMedia)) {
            return false;
        }
        RtspSdpMedia other = (RtspSdpMedia)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RtspSdpMediaDesc this$mediaDesc = this.getMediaDesc();
        RtspSdpMediaDesc other$mediaDesc = other.getMediaDesc();
        if (this$mediaDesc == null ? other$mediaDesc != null : !((Object)this$mediaDesc).equals(other$mediaDesc)) {
            return false;
        }
        RtspSdpConnection this$connection = this.getConnection();
        RtspSdpConnection other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !((Object)this$connection).equals(other$connection)) {
            return false;
        }
        RtspSdpBandwidth this$bandwidth = this.getBandwidth();
        RtspSdpBandwidth other$bandwidth = other.getBandwidth();
        if (this$bandwidth == null ? other$bandwidth != null : !((Object)this$bandwidth).equals(other$bandwidth)) {
            return false;
        }
        RtspSdpEncryptKey this$encryptKey = this.getEncryptKey();
        RtspSdpEncryptKey other$encryptKey = other.getEncryptKey();
        if (this$encryptKey == null ? other$encryptKey != null : !((Object)this$encryptKey).equals(other$encryptKey)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspSdpMedia;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RtspSdpMediaDesc $mediaDesc = this.getMediaDesc();
        result = result * 59 + ($mediaDesc == null ? 43 : ((Object)$mediaDesc).hashCode());
        RtspSdpConnection $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : ((Object)$connection).hashCode());
        RtspSdpBandwidth $bandwidth = this.getBandwidth();
        result = result * 59 + ($bandwidth == null ? 43 : ((Object)$bandwidth).hashCode());
        RtspSdpEncryptKey $encryptKey = this.getEncryptKey();
        result = result * 59 + ($encryptKey == null ? 43 : ((Object)$encryptKey).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "RtspSdpMedia(mediaDesc=" + this.getMediaDesc() + ", connection=" + this.getConnection() + ", bandwidth=" + this.getBandwidth() + ", encryptKey=" + this.getEncryptKey() + ", attributes=" + this.getAttributes() + ")";
    }
}

