/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.sdp;

import com.github.xingshuangs.iot.exceptions.RtspCommException;

public class RtspSdpOrigin {
    private String username;
    private String sessionId;
    private String sessionVersion;
    private String networkType;
    private String addressType;
    private String unicastAddress;

    public static RtspSdpOrigin fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("SDP\u89e3\u6790Origin\u90e8\u5206\u6570\u636e\u6e90\u9519\u8bef");
        }
        RtspSdpOrigin origin = new RtspSdpOrigin();
        String[] split = src.split(" ");
        if (split.length != 6) {
            throw new RtspCommException("RtspSdpOrigin\u6570\u636e\u6709\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790");
        }
        origin.username = split[0];
        origin.sessionId = split[1];
        origin.sessionVersion = split[2];
        origin.networkType = split[3];
        origin.addressType = split[4];
        origin.unicastAddress = split[5];
        return origin;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getSessionVersion() {
        return this.sessionVersion;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public String getUnicastAddress() {
        return this.unicastAddress;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setSessionVersion(String sessionVersion) {
        this.sessionVersion = sessionVersion;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public void setUnicastAddress(String unicastAddress) {
        this.unicastAddress = unicastAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspSdpOrigin)) {
            return false;
        }
        RtspSdpOrigin other = (RtspSdpOrigin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$sessionVersion = this.getSessionVersion();
        String other$sessionVersion = other.getSessionVersion();
        if (this$sessionVersion == null ? other$sessionVersion != null : !this$sessionVersion.equals(other$sessionVersion)) {
            return false;
        }
        String this$networkType = this.getNetworkType();
        String other$networkType = other.getNetworkType();
        if (this$networkType == null ? other$networkType != null : !this$networkType.equals(other$networkType)) {
            return false;
        }
        String this$addressType = this.getAddressType();
        String other$addressType = other.getAddressType();
        if (this$addressType == null ? other$addressType != null : !this$addressType.equals(other$addressType)) {
            return false;
        }
        String this$unicastAddress = this.getUnicastAddress();
        String other$unicastAddress = other.getUnicastAddress();
        return !(this$unicastAddress == null ? other$unicastAddress != null : !this$unicastAddress.equals(other$unicastAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspSdpOrigin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $sessionVersion = this.getSessionVersion();
        result = result * 59 + ($sessionVersion == null ? 43 : $sessionVersion.hashCode());
        String $networkType = this.getNetworkType();
        result = result * 59 + ($networkType == null ? 43 : $networkType.hashCode());
        String $addressType = this.getAddressType();
        result = result * 59 + ($addressType == null ? 43 : $addressType.hashCode());
        String $unicastAddress = this.getUnicastAddress();
        result = result * 59 + ($unicastAddress == null ? 43 : $unicastAddress.hashCode());
        return result;
    }

    public String toString() {
        return "RtspSdpOrigin(username=" + this.getUsername() + ", sessionId=" + this.getSessionId() + ", sessionVersion=" + this.getSessionVersion() + ", networkType=" + this.getNetworkType() + ", addressType=" + this.getAddressType() + ", unicastAddress=" + this.getUnicastAddress() + ")";
    }
}

