/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.sdp.attribute;

import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.utils.StringSpUtil;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

public class RtspSdpMediaAttrFmtp {
    private Integer number;
    private String profileLevelId;
    private Integer packetizationMode;
    private String spropParameterSets;
    private byte[] sps;
    private byte[] pps;

    public static RtspSdpMediaAttrFmtp fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("SDP\u89e3\u6790MediaAttrFmtp\u90e8\u5206\u6570\u636e\u6e90\u9519\u8bef");
        }
        RtspSdpMediaAttrFmtp rtpMap = new RtspSdpMediaAttrFmtp();
        int i = src.indexOf(" ");
        if (i == -1) {
            throw new RtspCommException("RtspSdpMediaAttrFmtp\u6570\u636e\u6709\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790");
        }
        rtpMap.number = Integer.parseInt(src.substring(0, i));
        String sub = src.substring(i + 1);
        List<String> stringList = StringSpUtil.splitOneStepByLine(sub, ";");
        for (String item : stringList) {
            int i1 = item.indexOf("=");
            if (i1 == -1) continue;
            String tmp = item.substring(i1 + 1);
            if (item.substring(0, i1).equals("profile-level-id")) {
                rtpMap.profileLevelId = tmp;
                continue;
            }
            if (item.substring(0, i1).equals("packetization-mode")) {
                rtpMap.packetizationMode = Integer.parseInt(tmp);
                continue;
            }
            if (!item.substring(0, i1).equals("sprop-parameter-sets")) continue;
            rtpMap.spropParameterSets = tmp;
            int i2 = tmp.indexOf(",");
            if (i2 < 0) continue;
            Base64.Decoder decoder = Base64.getDecoder();
            rtpMap.sps = decoder.decode(tmp.substring(0, i2));
            rtpMap.pps = decoder.decode(tmp.substring(i2 + 1));
        }
        return rtpMap;
    }

    public Integer getNumber() {
        return this.number;
    }

    public String getProfileLevelId() {
        return this.profileLevelId;
    }

    public Integer getPacketizationMode() {
        return this.packetizationMode;
    }

    public String getSpropParameterSets() {
        return this.spropParameterSets;
    }

    public byte[] getSps() {
        return this.sps;
    }

    public byte[] getPps() {
        return this.pps;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public void setProfileLevelId(String profileLevelId) {
        this.profileLevelId = profileLevelId;
    }

    public void setPacketizationMode(Integer packetizationMode) {
        this.packetizationMode = packetizationMode;
    }

    public void setSpropParameterSets(String spropParameterSets) {
        this.spropParameterSets = spropParameterSets;
    }

    public void setSps(byte[] sps) {
        this.sps = sps;
    }

    public void setPps(byte[] pps) {
        this.pps = pps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspSdpMediaAttrFmtp)) {
            return false;
        }
        RtspSdpMediaAttrFmtp other = (RtspSdpMediaAttrFmtp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$number = this.getNumber();
        Integer other$number = other.getNumber();
        if (this$number == null ? other$number != null : !((Object)this$number).equals(other$number)) {
            return false;
        }
        Integer this$packetizationMode = this.getPacketizationMode();
        Integer other$packetizationMode = other.getPacketizationMode();
        if (this$packetizationMode == null ? other$packetizationMode != null : !((Object)this$packetizationMode).equals(other$packetizationMode)) {
            return false;
        }
        String this$profileLevelId = this.getProfileLevelId();
        String other$profileLevelId = other.getProfileLevelId();
        if (this$profileLevelId == null ? other$profileLevelId != null : !this$profileLevelId.equals(other$profileLevelId)) {
            return false;
        }
        String this$spropParameterSets = this.getSpropParameterSets();
        String other$spropParameterSets = other.getSpropParameterSets();
        if (this$spropParameterSets == null ? other$spropParameterSets != null : !this$spropParameterSets.equals(other$spropParameterSets)) {
            return false;
        }
        if (!Arrays.equals(this.getSps(), other.getSps())) {
            return false;
        }
        return Arrays.equals(this.getPps(), other.getPps());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspSdpMediaAttrFmtp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : ((Object)$number).hashCode());
        Integer $packetizationMode = this.getPacketizationMode();
        result = result * 59 + ($packetizationMode == null ? 43 : ((Object)$packetizationMode).hashCode());
        String $profileLevelId = this.getProfileLevelId();
        result = result * 59 + ($profileLevelId == null ? 43 : $profileLevelId.hashCode());
        String $spropParameterSets = this.getSpropParameterSets();
        result = result * 59 + ($spropParameterSets == null ? 43 : $spropParameterSets.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSps());
        result = result * 59 + Arrays.hashCode(this.getPps());
        return result;
    }

    public String toString() {
        return "RtspSdpMediaAttrFmtp(number=" + this.getNumber() + ", profileLevelId=" + this.getProfileLevelId() + ", packetizationMode=" + this.getPacketizationMode() + ", spropParameterSets=" + this.getSpropParameterSets() + ", sps=" + Arrays.toString(this.getSps()) + ", pps=" + Arrays.toString(this.getPps()) + ")";
    }
}

