/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.enums;

import java.util.HashMap;
import java.util.Map;

public enum EArea {
    SYSTEM_INFO_OF_200_FAMILY(3),
    SYSTEM_FLAGS_OF_200_FAMILY(5),
    ANALOG_INPUTS_OF_200_FAMILY(6),
    ANALOG_OUTPUTS_OF_200_FAMILY(7),
    DIRECT_PERIPHERAL_ACCESS(-128),
    INPUTS(-127),
    OUTPUTS(-126),
    FLAGS(-125),
    DATA_BLOCKS(-124),
    INSTANCE_DATA_BLOCKS(-123),
    LOCAL_DATA(-122),
    UNKNOWN_YET(-121),
    S7_COUNTERS(28),
    S7_TIMERS(29),
    IEC_COUNTERS(30),
    IEC_TIMERS(31);

    private static Map<Byte, EArea> map;
    private final byte code;

    public static EArea from(byte data) {
        if (map == null) {
            map = new HashMap<Byte, EArea>();
            for (EArea item : EArea.values()) {
                map.put(item.code, item);
            }
        }
        return map.get(data);
    }

    private EArea(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }
}

