/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.protocol.s7.enums.EMessageType;
import com.github.xingshuangs.iot.protocol.s7.model.AckHeader;
import com.github.xingshuangs.iot.protocol.s7.model.Header;

public class HeaderBuilder {
    private HeaderBuilder() {
    }

    public static Header fromBytes(byte[] data) {
        EMessageType messageType = EMessageType.from(data[1]);
        switch (messageType) {
            case JOB: {
                return Header.fromBytes(data);
            }
            case ACK: 
            case ACK_DATA: {
                return AckHeader.fromBytes(data);
            }
            case USER_DATA: {
                return null;
            }
        }
        throw new S7CommException("COTP\u7684pduType\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u89e3\u6790");
    }
}

