/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EFileBlockType;
import com.github.xingshuangs.iot.utils.HexUtil;
import java.util.Arrays;

public class Mc7File {
    private byte[] data = new byte[0];
    private EFileBlockType blockType;
    private int blockNumber;
    private int mC7CodeLength;

    public int getLoadMemoryLength() {
        return this.data.length;
    }

    public static Mc7File fromBytes(byte[] data) {
        if (data == null || data.length < 36) {
            throw new IllegalArgumentException("MC7\u6587\u4ef6\u5185\u5bb9\u81f3\u5c11\u898136\u4e2a\u5b57\u8282\u957f\u5ea6");
        }
        ByteReadBuff buff = new ByteReadBuff(data);
        Mc7File res = new Mc7File();
        res.data = data;
        byte blockTypeByte = buff.getByte(5);
        res.blockType = EFileBlockType.from(HexUtil.toHexString(new byte[]{blockTypeByte}));
        res.blockNumber = buff.getUInt16(6);
        res.mC7CodeLength = buff.getUInt16(34);
        return res;
    }

    public byte[] getData() {
        return this.data;
    }

    public EFileBlockType getBlockType() {
        return this.blockType;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public int getMC7CodeLength() {
        return this.mC7CodeLength;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setBlockType(EFileBlockType blockType) {
        this.blockType = blockType;
    }

    public void setBlockNumber(int blockNumber) {
        this.blockNumber = blockNumber;
    }

    public void setMC7CodeLength(int mC7CodeLength) {
        this.mC7CodeLength = mC7CodeLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mc7File)) {
            return false;
        }
        Mc7File other = (Mc7File)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBlockNumber() != other.getBlockNumber()) {
            return false;
        }
        if (this.getMC7CodeLength() != other.getMC7CodeLength()) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        EFileBlockType this$blockType = this.getBlockType();
        EFileBlockType other$blockType = other.getBlockType();
        return !(this$blockType == null ? other$blockType != null : !((Object)((Object)this$blockType)).equals((Object)other$blockType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Mc7File;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBlockNumber();
        result = result * 59 + this.getMC7CodeLength();
        result = result * 59 + Arrays.hashCode(this.getData());
        EFileBlockType $blockType = this.getBlockType();
        result = result * 59 + ($blockType == null ? 43 : ((Object)((Object)$blockType)).hashCode());
        return result;
    }

    public String toString() {
        return "Mc7File(data=" + Arrays.toString(this.getData()) + ", blockType=" + (Object)((Object)this.getBlockType()) + ", blockNumber=" + this.getBlockNumber() + ", mC7CodeLength=" + this.getMC7CodeLength() + ")";
    }
}

