/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.protocol.common.IObjectByteArray;
import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.Parameter;
import java.util.Arrays;

public class PlcStopParameter
extends Parameter
implements IObjectByteArray {
    private byte[] unknownBytes = new byte[]{0, 0, 0, 0, 0};
    private int lengthPart = 0;
    private String piService = "";

    public void setPiService(String piService) {
        this.piService = piService;
        this.lengthPart = this.piService.length();
    }

    public PlcStopParameter() {
        this.functionCode = EFunctionCode.PLC_STOP;
    }

    @Override
    public int byteArrayLength() {
        return 7 + this.lengthPart;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(7 + this.lengthPart).putByte(this.functionCode.getCode()).putBytes(this.unknownBytes).putByte(this.lengthPart).putString(this.piService).getData();
    }

    public static PlcStopParameter fromBytes(byte[] data) {
        if (data.length < 7) {
            throw new S7CommException("StopParameter\u89e3\u6790\u6709\u8bef\uff0cStopParameter\u5b57\u8282\u6570\u7ec4\u957f\u5ea6 < 7");
        }
        ByteReadBuff buff = new ByteReadBuff(data);
        PlcStopParameter parameter = new PlcStopParameter();
        parameter.functionCode = EFunctionCode.from(buff.getByte());
        parameter.unknownBytes = buff.getBytes(5);
        parameter.lengthPart = buff.getByteToInt();
        parameter.piService = parameter.lengthPart == 0 ? "" : buff.getString(parameter.lengthPart);
        return parameter;
    }

    public static PlcStopParameter createDefault() {
        PlcStopParameter parameter = new PlcStopParameter();
        parameter.setPiService("P_PROGRAM");
        return parameter;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlcStopParameter)) {
            return false;
        }
        PlcStopParameter other = (PlcStopParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getLengthPart() != other.getLengthPart()) {
            return false;
        }
        if (!Arrays.equals(this.getUnknownBytes(), other.getUnknownBytes())) {
            return false;
        }
        String this$piService = this.getPiService();
        String other$piService = other.getPiService();
        return !(this$piService == null ? other$piService != null : !this$piService.equals(other$piService));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PlcStopParameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getLengthPart();
        result = result * 59 + Arrays.hashCode(this.getUnknownBytes());
        String $piService = this.getPiService();
        result = result * 59 + ($piService == null ? 43 : $piService.hashCode());
        return result;
    }

    public byte[] getUnknownBytes() {
        return this.unknownBytes;
    }

    public int getLengthPart() {
        return this.lengthPart;
    }

    public String getPiService() {
        return this.piService;
    }

    public void setUnknownBytes(byte[] unknownBytes) {
        this.unknownBytes = unknownBytes;
    }

    public void setLengthPart(int lengthPart) {
        this.lengthPart = lengthPart;
    }

    @Override
    public String toString() {
        return "PlcStopParameter(unknownBytes=" + Arrays.toString(this.getUnknownBytes()) + ", lengthPart=" + this.getLengthPart() + ", piService=" + this.getPiService() + ")";
    }
}

