/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.protocol.common.IObjectByteArray;
import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.Parameter;
import com.github.xingshuangs.iot.utils.BooleanUtil;

public class UploadAckParameter
extends Parameter
implements IObjectByteArray {
    protected boolean moreDataFollowing = false;
    protected boolean errorStatus = false;

    public UploadAckParameter() {
        this.functionCode = EFunctionCode.UPLOAD;
    }

    @Override
    public int byteArrayLength() {
        return 2;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(2).putByte(this.functionCode.getCode()).putByte((byte)(BooleanUtil.setBit(0, this.moreDataFollowing) | BooleanUtil.setBit(1, this.errorStatus))).getData();
    }

    public static UploadAckParameter fromBytes(byte[] data) {
        return UploadAckParameter.fromBytes(data, 0);
    }

    public static UploadAckParameter fromBytes(byte[] data, int offset) {
        if (data.length < 2) {
            throw new IndexOutOfBoundsException("\u89e3\u6790DownloadAckParameter\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        UploadAckParameter res = new UploadAckParameter();
        res.functionCode = EFunctionCode.from(buff.getByte(0));
        res.moreDataFollowing = buff.getBoolean(1, 0);
        res.errorStatus = buff.getBoolean(1, 1);
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadAckParameter)) {
            return false;
        }
        UploadAckParameter other = (UploadAckParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isMoreDataFollowing() != other.isMoreDataFollowing()) {
            return false;
        }
        return this.isErrorStatus() == other.isErrorStatus();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UploadAckParameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isMoreDataFollowing() ? 79 : 97);
        result = result * 59 + (this.isErrorStatus() ? 79 : 97);
        return result;
    }

    public boolean isMoreDataFollowing() {
        return this.moreDataFollowing;
    }

    public boolean isErrorStatus() {
        return this.errorStatus;
    }

    public void setMoreDataFollowing(boolean moreDataFollowing) {
        this.moreDataFollowing = moreDataFollowing;
    }

    public void setErrorStatus(boolean errorStatus) {
        this.errorStatus = errorStatus;
    }

    @Override
    public String toString() {
        return "UploadAckParameter(moreDataFollowing=" + this.isMoreDataFollowing() + ", errorStatus=" + this.isErrorStatus() + ")";
    }
}

