/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.service;

import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.net.client.TcpClientBasic;
import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.algorithm.S7ComGroup;
import com.github.xingshuangs.iot.protocol.s7.algorithm.S7ComItem;
import com.github.xingshuangs.iot.protocol.s7.algorithm.S7SequentialGroupAlg;
import com.github.xingshuangs.iot.protocol.s7.constant.ErrorCode;
import com.github.xingshuangs.iot.protocol.s7.enums.EDataVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.EDestinationFileSystem;
import com.github.xingshuangs.iot.protocol.s7.enums.EErrorClass;
import com.github.xingshuangs.iot.protocol.s7.enums.EFileBlockType;
import com.github.xingshuangs.iot.protocol.s7.enums.EParamVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.EPduType;
import com.github.xingshuangs.iot.protocol.s7.enums.EPlcType;
import com.github.xingshuangs.iot.protocol.s7.enums.EReturnCode;
import com.github.xingshuangs.iot.protocol.s7.model.AckHeader;
import com.github.xingshuangs.iot.protocol.s7.model.DataItem;
import com.github.xingshuangs.iot.protocol.s7.model.Mc7File;
import com.github.xingshuangs.iot.protocol.s7.model.NckRequestBuilder;
import com.github.xingshuangs.iot.protocol.s7.model.ReadWriteDatum;
import com.github.xingshuangs.iot.protocol.s7.model.ReadWriteParameter;
import com.github.xingshuangs.iot.protocol.s7.model.RequestItem;
import com.github.xingshuangs.iot.protocol.s7.model.RequestNckItem;
import com.github.xingshuangs.iot.protocol.s7.model.ReturnItem;
import com.github.xingshuangs.iot.protocol.s7.model.S7Data;
import com.github.xingshuangs.iot.protocol.s7.model.SetupComParameter;
import com.github.xingshuangs.iot.protocol.s7.model.StartUploadAckParameter;
import com.github.xingshuangs.iot.protocol.s7.model.TPKT;
import com.github.xingshuangs.iot.protocol.s7.model.UpDownloadDatum;
import com.github.xingshuangs.iot.protocol.s7.model.UploadAckParameter;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PLCNetwork
extends TcpClientBasic {
    private static final Logger log = LoggerFactory.getLogger(PLCNetwork.class);
    private final Object objLock = new Object();
    protected EPlcType plcType = EPlcType.S1200;
    protected int rack = 0;
    protected int slot = 1;
    protected int pduLength;
    private boolean persistence = true;
    private Consumer<byte[]> comCallback;

    public void setComCallback(Consumer<byte[]> comCallback) {
        this.comCallback = comCallback;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    public void setPersistence(boolean persistence) {
        this.persistence = persistence;
    }

    public EPlcType getPlcType() {
        return this.plcType;
    }

    public int getRack() {
        return this.rack;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getPduLength() {
        return this.pduLength;
    }

    public PLCNetwork() {
    }

    public PLCNetwork(String host, int port) {
        super(host, port);
        this.tag = "S7";
    }

    @Override
    public void connect() {
        try {
            super.connect();
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    @Override
    protected void doAfterConnected() {
        this.connectionRequest();
        this.pduLength = this.connectDtData();
        log.debug("PLC[{}]\u63e1\u624b\u6210\u529f\uff0c\u673a\u67b6\u53f7[{}]\uff0c\u69fd\u53f7[{}]\uff0cPDU\u957f\u5ea6[{}]", new Object[]{this.plcType, this.rack, this.slot, this.pduLength});
    }

    private void connectionRequest() {
        int local = 256;
        int remote = 768;
        switch (this.plcType) {
            case S200: {
                local = 19799;
                remote = 19799;
                break;
            }
            case S200_SMART: {
                local = 4096;
                remote = 768;
                break;
            }
            case S300: 
            case S400: 
            case S1200: 
            case S1500: {
                remote += 32 * this.rack + this.slot;
                break;
            }
            case SINUMERIK_828D: {
                local = 1024;
                remote = 3332;
            }
        }
        S7Data req = S7Data.createConnectRequest(local, remote);
        S7Data ack = this.readFromServer(req);
        if (ack.getCotp().getPduType() != EPduType.CONNECT_CONFIRM) {
            throw new S7CommException("\u8fde\u63a5\u8bf7\u6c42\u88ab\u62d2\u7edd");
        }
    }

    private int connectDtData() {
        S7Data req = S7Data.createConnectDtData(this.pduLength);
        S7Data ack = this.readFromServer(req);
        if (ack.getCotp().getPduType() != EPduType.DT_DATA) {
            throw new S7CommException("\u8fde\u63a5Setup\u54cd\u5e94\u9519\u8bef");
        }
        if (ack.getHeader() == null || ack.getHeader().byteArrayLength() != 12) {
            throw new S7CommException("\u8fde\u63a5Setup\u54cd\u5e94\u9519\u8bef\uff0c\u7f3a\u5931\u54cd\u5e94\u5934header\u6216\u54cd\u5e94\u5934\u957f\u5ea6\u4e0d\u591f[12]");
        }
        int length = ((SetupComParameter)ack.getParameter()).getPduLength();
        if (length <= 0) {
            throw new S7CommException("PDU\u7684\u6700\u5927\u957f\u5ea6\u5c0f\u4e8e0");
        }
        return length;
    }

    private S7Data readFromServer(S7Data req) {
        byte[] sendData = req.toByteArray();
        byte[] total = this.readFromServer(sendData);
        S7Data ack = S7Data.fromBytes(total);
        this.checkPostedCom(req, ack);
        return ack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFromServer(byte[] sendData) {
        byte[] total;
        int len;
        if (this.comCallback != null) {
            this.comCallback.accept(sendData);
        }
        if (this.pduLength > 0 && sendData.length - 7 > this.pduLength) {
            throw new S7CommException(String.format("\u53d1\u9001\u8bf7\u6c42\u7684\u5b57\u8282\u6570\u8fc7\u957f[%d]\uff0c\u5df2\u7ecf\u5927\u4e8e\u6700\u5927\u7684PDU\u957f\u5ea6[%d]", sendData.length, this.pduLength));
        }
        Object object = this.objLock;
        synchronized (object) {
            this.write(sendData);
            byte[] data = new byte[4];
            len = this.read(data);
            if (len < 4) {
                throw new S7CommException(" TPKT \u65e0\u6548\uff0c\u957f\u5ea6\u4e0d\u4e00\u81f4");
            }
            TPKT tpkt = TPKT.fromBytes(data);
            total = new byte[tpkt.getLength()];
            System.arraycopy(data, 0, total, 0, data.length);
            len = this.read(total, 4, tpkt.getLength() - 4);
        }
        if (len < total.length - 4) {
            throw new S7CommException(" TPKT\u540e\u9762\u7684\u6570\u636e\u957f\u5ea6\uff0c\u957f\u5ea6\u4e0d\u4e00\u81f4");
        }
        if (this.comCallback != null) {
            this.comCallback.accept(total);
        }
        return total;
    }

    public S7Data readFromServerByPersistence(S7Data req) {
        try {
            S7Data s7Data = this.readFromServer(req);
            return s7Data;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    public byte[] readFromServerByPersistence(byte[] req) {
        try {
            byte[] byArray = this.readFromServer(req);
            return byArray;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    private void checkPostedCom(S7Data req, S7Data ack) {
        if (ack.getHeader() == null) {
            return;
        }
        AckHeader ackHeader = (AckHeader)ack.getHeader();
        if (ackHeader.getErrorClass() == null) {
            throw new S7CommException(String.format("\u54cd\u5e94\u5f02\u5e38\uff0c\u672a\u77e5\u5f02\u5e38\uff1a%s", ErrorCode.MAP.getOrDefault(ackHeader.getErrorCode(), "\u9519\u8bef\u7801\u4e0d\u5b58\u5728")));
        }
        if (ackHeader.getErrorClass() != EErrorClass.NO_ERROR) {
            throw new S7CommException(String.format("\u54cd\u5e94\u5f02\u5e38\uff0c\u9519\u8bef\u7c7b\u578b\uff1a%s\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", ackHeader.getErrorClass().getDescription(), ErrorCode.MAP.getOrDefault(ackHeader.getErrorCode(), "\u9519\u8bef\u7801\u4e0d\u5b58\u5728")));
        }
        if (ackHeader.getPduReference() != req.getHeader().getPduReference()) {
            throw new S7CommException("pdu\u5e94\u7528\u7f16\u53f7\u4e0d\u4e00\u81f4\uff0c\u6570\u636e\u6709\u8bef");
        }
        if (ack.getDatum() == null) {
            return;
        }
        if (!(ack.getDatum() instanceof ReadWriteDatum)) {
            return;
        }
        ReadWriteDatum datum = (ReadWriteDatum)ack.getDatum();
        List<ReturnItem> returnItems = datum.getReturnItems();
        ReadWriteParameter parameter = (ReadWriteParameter)req.getParameter();
        if (returnItems.size() != parameter.getItemCount()) {
            throw new S7CommException("\u8fd4\u56de\u7684\u6570\u636e\u4e2a\u6570\u548c\u8bf7\u6c42\u7684\u6570\u636e\u4e2a\u6570\u4e0d\u4e00\u81f4");
        }
        returnItems.forEach(x -> {
            if (x.getReturnCode() != EReturnCode.SUCCESS) {
                throw new S7CommException(String.format("\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", x.getReturnCode().getDescription()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataItem> readS7Data(List<RequestItem> requestItems) {
        if (requestItems == null || requestItems.isEmpty()) {
            throw new S7CommException("\u8bf7\u6c42\u9879\u7f3a\u5931\uff0c\u65e0\u6cd5\u83b7\u53d6\u6570\u636e");
        }
        List<Integer> rawNumbers = requestItems.stream().map(RequestItem::getCount).collect(Collectors.toList());
        List<DataItem> resultList = requestItems.stream().map(x -> DataItem.createReq(new byte[x.getCount()], x.getVariableType() == EParamVariableType.BIT ? EDataVariableType.BIT : EDataVariableType.BYTE_WORD_DWORD)).collect(Collectors.toList());
        List<S7ComGroup> s7ComGroups = S7SequentialGroupAlg.readRecombination(rawNumbers, this.pduLength - 14, 5, 12);
        try {
            s7ComGroups.forEach(x -> {
                List<S7ComItem> comItemList = x.getItems();
                List<RequestItem> newRequestItems = comItemList.stream().map(i -> {
                    RequestItem item = ((RequestItem)requestItems.get(i.getIndex())).copy();
                    item.setCount(i.getRipeSize());
                    item.setByteAddress(item.getByteAddress() + i.getSplitOffset());
                    return item;
                }).collect(Collectors.toList());
                S7Data req = S7Data.createReadRequest(newRequestItems);
                S7Data ack = this.readFromServer(req);
                ReadWriteDatum datum = (ReadWriteDatum)ack.getDatum();
                List dataItems = datum.getReturnItems().stream().map(DataItem.class::cast).collect(Collectors.toList());
                for (int i2 = 0; i2 < comItemList.size(); ++i2) {
                    S7ComItem comItem = comItemList.get(i2);
                    byte[] src = ((DataItem)dataItems.get(i2)).getData();
                    byte[] des = ((DataItem)resultList.get(comItem.getIndex())).getData();
                    System.arraycopy(src, 0, des, comItem.getSplitOffset(), src.length);
                }
            });
            List<DataItem> list = resultList;
            return list;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    public DataItem readS7Data(RequestItem requestItem) {
        return this.readS7Data(Collections.singletonList(requestItem)).get(0);
    }

    public void writeS7Data(RequestItem requestItem, DataItem dataItem) {
        this.writeS7Data(Collections.singletonList(requestItem), Collections.singletonList(dataItem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeS7Data(List<RequestItem> requestItems, List<DataItem> dataItems) {
        if (requestItems.size() != dataItems.size()) {
            throw new S7CommException("\u5199\u64cd\u4f5c\u8fc7\u7a0b\u4e2d\uff0crequestItems\u548cdataItems\u6570\u636e\u4e2a\u6570\u4e0d\u4e00\u81f4");
        }
        List<Integer> rawNumbers = requestItems.stream().map(RequestItem::getCount).collect(Collectors.toList());
        List<S7ComGroup> s7ComGroups = S7SequentialGroupAlg.writeRecombination(rawNumbers, this.pduLength - 12, 17);
        try {
            s7ComGroups.forEach(x -> {
                List<S7ComItem> comItemList = x.getItems();
                List<RequestItem> newRequestItems = comItemList.stream().map(i -> {
                    RequestItem item = ((RequestItem)requestItems.get(i.getIndex())).copy();
                    item.setCount(i.getRipeSize());
                    item.setByteAddress(item.getByteAddress() + i.getSplitOffset());
                    return item;
                }).collect(Collectors.toList());
                List<DataItem> newDataItems = comItemList.stream().map(i -> {
                    DataItem item = ((DataItem)dataItems.get(i.getIndex())).copy();
                    item.setCount(i.getRipeSize());
                    item.setData(ByteReadBuff.newInstance(item.getData()).getBytes(i.getSplitOffset(), i.getRipeSize()));
                    return item;
                }).collect(Collectors.toList());
                S7Data req = S7Data.createWriteRequest(newRequestItems, newDataItems);
                this.readFromServer(req);
            });
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    public DataItem readS7NckData(RequestNckItem requestItem) {
        return this.readS7NckData(Collections.singletonList(requestItem)).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataItem> readS7NckData(List<RequestNckItem> requestItems) {
        try {
            S7Data s7Data = NckRequestBuilder.creatNckRequest(requestItems);
            S7Data ack = this.readFromServer(s7Data);
            ReadWriteDatum datum = (ReadWriteDatum)ack.getDatum();
            List<DataItem> list = datum.getReturnItems().stream().map(DataItem.class::cast).collect(Collectors.toList());
            return list;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(Mc7File mc7) {
        try {
            EDestinationFileSystem destinationFileSystem = EDestinationFileSystem.P;
            S7Data reqStartDownload = S7Data.createStartDownload(mc7.getBlockType(), mc7.getBlockNumber(), destinationFileSystem, mc7.getLoadMemoryLength(), mc7.getMC7CodeLength());
            this.readFromServer(reqStartDownload);
            ByteReadBuff buff = new ByteReadBuff(mc7.getData());
            while (buff.getRemainSize() > 0) {
                boolean moreDataFollowing = buff.getRemainSize() > this.pduLength - 32;
                byte[] tmpData = buff.getBytes(Math.min(buff.getRemainSize(), this.pduLength - 32));
                S7Data reqDownload = S7Data.createDownload(mc7.getBlockType(), mc7.getBlockNumber(), destinationFileSystem, moreDataFollowing, tmpData);
                this.readFromServer(reqDownload);
            }
            S7Data reqEndDownload = S7Data.createEndDownload(mc7.getBlockType(), mc7.getBlockNumber(), destinationFileSystem);
            this.readFromServer(reqEndDownload);
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] uploadFile(EFileBlockType blockType, int blockNumber) {
        try {
            S7Data reqStartDownload = S7Data.createStartUpload(blockType, blockNumber, EDestinationFileSystem.A);
            S7Data ackStartDownload = this.readFromServer(reqStartDownload);
            StartUploadAckParameter startUploadAckParameter = (StartUploadAckParameter)ackStartDownload.getParameter();
            ByteWriteBuff buff = new ByteWriteBuff(startUploadAckParameter.getBlockLength());
            UploadAckParameter uploadAckParameter = new UploadAckParameter();
            uploadAckParameter.setMoreDataFollowing(true);
            while (uploadAckParameter.isMoreDataFollowing()) {
                S7Data reqUpload = S7Data.createUpload(startUploadAckParameter.getId());
                S7Data ackUpload = this.readFromServer(reqUpload);
                uploadAckParameter = (UploadAckParameter)ackUpload.getParameter();
                if (uploadAckParameter.isErrorStatus()) {
                    throw new S7CommException("\u4e0a\u4f20\u53d1\u751f\u9519\u8bef");
                }
                UpDownloadDatum datum = (UpDownloadDatum)ackUpload.getDatum();
                buff.putBytes(datum.getData());
            }
            S7Data reqEndUpload = S7Data.createEndUpload(startUploadAckParameter.getId());
            this.readFromServer(reqEndUpload);
            byte[] byArray = buff.getData();
            return byArray;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }
}

