/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.service;

import com.github.xingshuangs.iot.net.server.TcpServerBasic;
import com.github.xingshuangs.iot.protocol.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EDataVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.EErrorClass;
import com.github.xingshuangs.iot.protocol.s7.enums.EMessageType;
import com.github.xingshuangs.iot.protocol.s7.enums.EParamVariableType;
import com.github.xingshuangs.iot.protocol.s7.enums.EPduType;
import com.github.xingshuangs.iot.protocol.s7.enums.EReturnCode;
import com.github.xingshuangs.iot.protocol.s7.model.COTPConnection;
import com.github.xingshuangs.iot.protocol.s7.model.COTPData;
import com.github.xingshuangs.iot.protocol.s7.model.DataItem;
import com.github.xingshuangs.iot.protocol.s7.model.ReadWriteDatum;
import com.github.xingshuangs.iot.protocol.s7.model.ReadWriteParameter;
import com.github.xingshuangs.iot.protocol.s7.model.RequestItem;
import com.github.xingshuangs.iot.protocol.s7.model.ReturnItem;
import com.github.xingshuangs.iot.protocol.s7.model.S7Data;
import com.github.xingshuangs.iot.protocol.s7.utils.AddressUtil;
import com.github.xingshuangs.iot.utils.BooleanUtil;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7PLCServer
extends TcpServerBasic {
    private static final Logger log = LoggerFactory.getLogger(S7PLCServer.class);
    private final Object objLock = new Object();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final HashMap<String, byte[]> dataMap = new HashMap();

    public S7PLCServer() {
        this(102);
    }

    public S7PLCServer(int port) {
        this.port = port;
        this.dataMap.put("DB1", new byte[65536]);
        this.dataMap.put("M", new byte[65536]);
        this.dataMap.put("I", new byte[65536]);
        this.dataMap.put("Q", new byte[65536]);
        this.dataMap.put("T", new byte[65536]);
        this.dataMap.put("C", new byte[65536]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAvailableAreas() {
        Object object = this.objLock;
        synchronized (object) {
            return this.dataMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDBArea(int ... dbNumbers) {
        log.debug("\u670d\u52a1\u7aef\u6570\u636e\u533a\u6dfb\u52a0DB{}", (Object)dbNumbers);
        Object object = this.objLock;
        synchronized (object) {
            for (int x : dbNumbers) {
                String name = String.format("DB%s", x);
                this.dataMap.computeIfAbsent(name, key -> new byte[65536]);
            }
        }
    }

    @Override
    protected boolean checkHandshake(Socket socket) {
        S7Data s7Data = this.readS7DataFromClient(socket);
        if (!(s7Data.getCotp() instanceof COTPConnection) || s7Data.getCotp().getPduType() != EPduType.CONNECT_REQUEST) {
            log.error("\u5ba2\u6237\u7aef[{}]\u63e1\u624b\u5931\u8d25\uff0c\u4e0d\u662f\u8fde\u63a5\u8bf7\u6c42", (Object)socket.getRemoteSocketAddress());
            return false;
        }
        S7Data connectConfirm = S7Data.createConnectConfirm(s7Data);
        this.write(socket, connectConfirm.toByteArray());
        s7Data = this.readS7DataFromClient(socket);
        if (!(s7Data.getCotp() instanceof COTPData) || s7Data.getCotp().getPduType() != EPduType.DT_DATA) {
            log.error("\u5ba2\u6237\u7aef[{}]\u63e1\u624b\u5931\u8d25\uff0c\u4e0d\u662f\u53c2\u6570\u8bbe\u7f6e", (Object)socket.getRemoteSocketAddress());
            return false;
        }
        S7Data connectAckDtData = S7Data.createConnectAckDtData(s7Data);
        this.write(socket, connectAckDtData.toByteArray());
        log.debug("\u5ba2\u6237\u7aef[{}]\u63e1\u624b\u6210\u529f", (Object)socket.getRemoteSocketAddress());
        return true;
    }

    @Override
    protected void doClientHandle(Socket socket) {
        S7Data response;
        S7Data req = this.readS7DataFromClient(socket);
        if (!(req.getCotp() instanceof COTPData) || req.getCotp().getPduType() != EPduType.DT_DATA || req.getHeader().getMessageType() != EMessageType.JOB) {
            response = S7Data.createErrorResponse(req, EErrorClass.ERROR_ON_SUPPLIES, 34048);
            this.write(socket, response.toByteArray());
        }
        try {
            switch (req.getParameter().getFunctionCode()) {
                case READ_VARIABLE: {
                    this.readVariableHandle(socket, req);
                    return;
                }
                case WRITE_VARIABLE: {
                    this.writeVariableHandle(socket, req);
                    return;
                }
            }
            response = S7Data.createErrorResponse(req, EErrorClass.ERROR_ON_SUPPLIES, 34048);
            this.write(socket, response.toByteArray());
        }
        catch (Exception e) {
            S7Data response2 = S7Data.createErrorResponse(req, EErrorClass.ERROR_ON_SERVICE_PROCESSING, 33796);
            this.write(socket, response2.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readVariableHandle(Socket socket, S7Data req) {
        ReadWriteParameter parameter = (ReadWriteParameter)req.getParameter();
        ArrayList<ReturnItem> returnItems = new ArrayList<ReturnItem>();
        try {
            this.rwLock.readLock().lock();
            parameter.getRequestItems().forEach(p1 -> {
                byte[] data;
                RequestItem p = (RequestItem)p1;
                String area = AddressUtil.parseArea(p);
                if (!this.dataMap.containsKey(area)) {
                    log.error("\u5ba2\u6237\u7aef[{}]\u8bfb\u53d6[{}]\u6570\u636e\uff0c\u533a\u57df[{}]\uff0c\u5b57\u8282\u7d22\u5f15[{}]\uff0c\u4f4d\u7d22\u5f15[{}]\uff0c\u957f\u5ea6[{}]\uff0c\u65e0\u8be5\u533a\u57df\u5730\u5740\u6570\u636e", new Object[]{socket.getRemoteSocketAddress(), p.getVariableType(), area, p.getByteAddress(), p.getBitAddress(), p.getCount()});
                    returnItems.add(ReturnItem.createDefault(EReturnCode.OBJECT_DOES_NOT_EXIST));
                    return;
                }
                byte[] bytes = this.dataMap.get(area);
                ByteReadBuff buff = new ByteReadBuff(bytes);
                if (p.getVariableType() == EParamVariableType.BYTE) {
                    data = buff.getBytes(p.getByteAddress(), p.getCount());
                } else {
                    byte[] byArray;
                    byte oldData = buff.getByte(p.getByteAddress());
                    if (BooleanUtil.getValue(oldData, p.getBitAddress())) {
                        byte[] byArray2 = new byte[1];
                        byArray = byArray2;
                        byArray2[0] = 1;
                    } else {
                        byte[] byArray3 = new byte[1];
                        byArray = byArray3;
                        byArray3[0] = 0;
                    }
                    data = byArray;
                }
                log.debug("\u5ba2\u6237\u7aef[{}]\u8bfb\u53d6[{}]\u6570\u636e\uff0c\u533a\u57df[{}]\uff0c\u5b57\u8282\u7d22\u5f15[{}]\uff0c\u4f4d\u7d22\u5f15[{}]\uff0c\u957f\u5ea6[{}]\uff0c\u533a\u57df\u5730\u5740\u6570\u636e{}", new Object[]{socket.getRemoteSocketAddress(), p.getVariableType(), area, p.getByteAddress(), p.getBitAddress(), p.getCount(), data});
                DataItem dataItem = DataItem.createAckBy(data, p.getVariableType() == EParamVariableType.BYTE ? EDataVariableType.BYTE_WORD_DWORD : EDataVariableType.BIT);
                returnItems.add(dataItem);
            });
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        S7Data ack = S7Data.createReadWriteResponse(req, returnItems);
        this.write(socket, ack.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVariableHandle(Socket socket, S7Data req) {
        ReadWriteParameter parameter = (ReadWriteParameter)req.getParameter();
        ReadWriteDatum datum = (ReadWriteDatum)req.getDatum();
        List dataItems = datum.getReturnItems().stream().map(DataItem.class::cast).collect(Collectors.toList());
        ArrayList<ReturnItem> returnItems = new ArrayList<ReturnItem>();
        try {
            this.rwLock.writeLock().lock();
            for (int i = 0; i < parameter.getItemCount(); ++i) {
                RequestItem p = (RequestItem)parameter.getRequestItems().get(i);
                DataItem d = (DataItem)dataItems.get(i);
                String area = AddressUtil.parseArea(p);
                if (!this.dataMap.containsKey(area)) {
                    log.error("\u5ba2\u6237\u7aef[{}]\u5199\u5165[{}]\u6570\u636e\uff0c\u533a\u57df[{}]\uff0c\u5b57\u8282\u7d22\u5f15[{}]\uff0c\u4f4d\u7d22\u5f15[{}]\uff0c\u957f\u5ea6[{}]\uff0c\u65e0\u8be5\u533a\u57df\u5730\u5740", new Object[]{socket.getRemoteSocketAddress(), p.getVariableType(), area, p.getByteAddress(), p.getBitAddress(), p.getCount()});
                    returnItems.add(ReturnItem.createDefault(EReturnCode.OBJECT_DOES_NOT_EXIST));
                    continue;
                }
                byte[] bytes = this.dataMap.get(area);
                if (p.getVariableType() == EParamVariableType.BYTE) {
                    System.arraycopy(d.getData(), 0, bytes, p.getByteAddress(), d.getData().length);
                } else {
                    byte newData = BooleanUtil.setBit(bytes[p.getByteAddress()], p.getBitAddress(), d.getData()[0] == 1);
                    System.arraycopy(new byte[]{newData}, 0, bytes, p.getByteAddress(), 1);
                }
                log.debug("\u5ba2\u6237\u7aef[{}]\u5199\u5165[{}]\u6570\u636e\uff0c\u533a\u57df[{}]\uff0c\u5b57\u8282\u7d22\u5f15[{}]\uff0c\u4f4d\u7d22\u5f15[{}]\uff0c\u957f\u5ea6[{}]\uff0c\u533a\u57df\u5730\u5740\u6570\u636e{}", new Object[]{socket.getRemoteSocketAddress(), p.getVariableType(), area, p.getByteAddress(), p.getBitAddress(), p.getCount(), d.getData()});
                returnItems.add(ReturnItem.createDefault(EReturnCode.SUCCESS));
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        S7Data ack = S7Data.createReadWriteResponse(req, returnItems);
        this.write(socket, ack.toByteArray());
    }

    private S7Data readS7DataFromClient(Socket socket) {
        byte[] data = this.readClientData(socket);
        return S7Data.fromBytes(data);
    }
}

