/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.utils;

import com.github.xingshuangs.iot.utils.IntegerUtil;
import com.github.xingshuangs.iot.utils.LongUtil;

public class FloatUtil {
    private FloatUtil() {
    }

    public static byte[] toByteArray(double data) {
        return LongUtil.toByteArray(Double.doubleToLongBits(data), false);
    }

    public static byte[] toByteArray(double data, boolean littleEndian) {
        return LongUtil.toByteArray(Double.doubleToLongBits(data), littleEndian);
    }

    public static byte[] toByteArray(float data) {
        return IntegerUtil.toByteArray(Float.floatToIntBits(data), false);
    }

    public static byte[] toByteArray(float data, boolean littleEndian) {
        return IntegerUtil.toByteArray(Float.floatToIntBits(data), littleEndian);
    }

    public static float toFloat32(byte[] data) {
        return FloatUtil.toFloat32(data, 0, false);
    }

    public static float toFloat32(byte[] data, int offset) {
        return FloatUtil.toFloat32(data, offset, false);
    }

    public static float toFloat32(byte[] data, int offset, boolean littleEndian) {
        if (data.length < 4) {
            throw new IndexOutOfBoundsException("data\u5c0f\u4e8e4\u4e2a\u5b57\u8282");
        }
        if (offset + 4 > data.length) {
            throw new IndexOutOfBoundsException("offset + 4 > \u5b57\u8282\u957f\u5ea6");
        }
        int b = littleEndian ? 3 : 0;
        int d = littleEndian ? 1 : -1;
        int l = (data[offset + b - d * 0] & 0xFF) << 24 | (data[offset + b - d * 1] & 0xFF) << 16 | (data[offset + b - d * 2] & 0xFF) << 8 | (data[offset + b - d * 3] & 0xFF) << 0;
        return Float.intBitsToFloat(l);
    }

    public static double toFloat64(byte[] data) {
        return FloatUtil.toFloat64(data, 0, false);
    }

    public static double toFloat64(byte[] data, int offset) {
        return FloatUtil.toFloat64(data, offset, false);
    }

    public static double toFloat64(byte[] data, int offset, boolean littleEndian) {
        if (data.length < 8) {
            throw new IndexOutOfBoundsException("data\u5c0f\u4e8e8\u4e2a\u5b57\u8282");
        }
        if (offset + 8 > data.length) {
            throw new IndexOutOfBoundsException("offset + 8 > \u5b57\u8282\u957f\u5ea6");
        }
        int b = littleEndian ? 7 : 0;
        int d = littleEndian ? 1 : -1;
        long l = (long)(data[offset + b - d * 0] & 0xFF) << 56 | (long)(data[offset + b - d * 1] & 0xFF) << 48 | (long)(data[offset + b - d * 2] & 0xFF) << 40 | (long)(data[offset + b - d * 3] & 0xFF) << 32 | (long)(data[offset + b - d * 4] & 0xFF) << 24 | (long)(data[offset + b - d * 5] & 0xFF) << 16 | (long)(data[offset + b - d * 6] & 0xFF) << 8 | (long)(data[offset + b - d * 7] & 0xFF);
        return Double.longBitsToDouble(l);
    }
}

