/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.utils;

public class ShortUtil {
    private ShortUtil() {
    }

    public static byte[] toByteArray(int data, boolean littleEndian) {
        byte[] bytes = new byte[2];
        if (littleEndian) {
            bytes[0] = (byte)(data & 0xFF);
            bytes[1] = (byte)(data >> 8 & 0xFF);
        } else {
            bytes[0] = (byte)(data >> 8 & 0xFF);
            bytes[1] = (byte)(data & 0xFF);
        }
        return bytes;
    }

    public static byte[] toByteArray(int data) {
        return ShortUtil.toByteArray(data, false);
    }

    public static byte[] toByteArray(short data) {
        return ShortUtil.toByteArray(data, false);
    }

    public static short toInt16(byte[] data) {
        return ShortUtil.toInt16(data, 0, false);
    }

    public static short toInt16(byte[] data, int offset) {
        return ShortUtil.toInt16(data, offset, false);
    }

    public static short toInt16(byte[] data, int offset, boolean littleEndian) {
        if (data.length < 2) {
            throw new IndexOutOfBoundsException("data\u5c0f\u4e8e2\u4e2a\u5b57\u8282");
        }
        if (offset + 2 > data.length) {
            throw new IndexOutOfBoundsException("offset + 2 > \u5b57\u8282\u957f\u5ea6");
        }
        int b = littleEndian ? 1 : 0;
        int d = littleEndian ? 1 : -1;
        return (short)((data[offset + b - d * 0] & 0xFF) << 8 | (data[offset + b - d * 1] & 0xFF) << 0);
    }

    public static int toUInt16(byte[] data) {
        return ShortUtil.toUInt16(data, 0, false);
    }

    public static int toUInt16(byte[] data, int offset) {
        return ShortUtil.toUInt16(data, offset, false);
    }

    public static int toUInt16(byte[] data, int offset, boolean littleEndian) {
        if (data.length < 2) {
            throw new IndexOutOfBoundsException("data\u5c0f\u4e8e2\u4e2a\u5b57\u8282");
        }
        if (offset + 2 > data.length) {
            throw new IndexOutOfBoundsException("offset + 2 > \u5b57\u8282\u957f\u5ea6");
        }
        int b = littleEndian ? 1 : 0;
        int d = littleEndian ? 1 : -1;
        return (data[offset + b - d * 0] & 0xFF) << 8 | (data[offset + b - d * 1] & 0xFF) << 0;
    }
}

