/*
 * Decompiled with CFR 0.152.
 */
package com.paas.utilities.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.paas.utilities.http.PaaSHttpThreadFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public class HttpClient {
    private static final OkHttpClient.Builder okBuilder;
    private static final Logger logger;

    public static <R> Request<R> buildRequest(Class<R> reqType) {
        return HttpClient.buildRequest(reqType, false);
    }

    public static <R> Request<R> buildRequest(Class<R> reqType, boolean isAsync) {
        return new Request<R>(reqType, isAsync);
    }

    public static Request<Object> buildRequest() {
        return HttpClient.buildRequest(Object.class, false);
    }

    public static Request<Object> buildRequest(boolean isAsync) {
        return HttpClient.buildRequest(Object.class, isAsync);
    }

    static Response request(final Request req, final Response rsp) {
        Request.Builder reqBuilder = new Request.Builder();
        reqBuilder = reqBuilder.url(req.url);
        Map headers = req.headers;
        for (Map.Entry entry : headers.entrySet()) {
            reqBuilder = reqBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        RequestBody requestBody = null != req.contentType ? RequestBody.create((MediaType)MediaType.parse((String)req.contentType.name), (byte[])req.bytes) : RequestBody.create((MediaType)MediaType.get((String)ContentType.APPLICATION_FORM_URLENCODED.name), (byte[])req.bytes);
        switch (req.method) {
            case POST: {
                reqBuilder = reqBuilder.post(requestBody);
                break;
            }
            case PUT: {
                reqBuilder = reqBuilder.put(requestBody);
                break;
            }
            case HEAD: {
                reqBuilder = reqBuilder.head();
                break;
            }
            case PATCH: {
                reqBuilder = reqBuilder.patch(requestBody);
                break;
            }
            case TRACE: {
                reqBuilder = reqBuilder.header("method", Method.TRACE.name());
                break;
            }
            case DELETE: {
                reqBuilder = reqBuilder.delete(requestBody);
                break;
            }
            case OPTIONS: {
                reqBuilder = reqBuilder.header("method", Method.OPTIONS.name());
                break;
            }
            default: {
                reqBuilder = reqBuilder.get();
            }
        }
        Call call = req.okHttpClient.newCall(reqBuilder.build());
        if (req.isAsync) {
            call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    rsp.currentTimeMillis = System.currentTimeMillis();
                    rsp.message = e.getMessage();
                    logger.info("------ > Call Service | Failure Content: " + rsp.message + " Cost\uff1a" + (rsp.currentTimeMillis - req.currentTimeMillis));
                    HttpClient.notifyRequest(req);
                }

                public void onResponse(Call call, okhttp3.Response response) throws IOException {
                    rsp.code = response.code();
                    ResponseBody responseBody = response.body();
                    if (null != responseBody) {
                        rsp.bytes = responseBody.bytes();
                    }
                    rsp.currentTimeMillis = System.currentTimeMillis();
                    logger.info("------ > Call Service | Response Status: " + rsp.code);
                    logger.info("------ > Call Service | Response Content: " + HttpClient.logBytes(rsp.bytes) + " Cost\uff1a" + (rsp.currentTimeMillis - req.currentTimeMillis));
                    HttpClient.notifyRequest(req);
                }
            });
        } else {
            try {
                okhttp3.Response response = call.execute();
                rsp.code = response.code();
                ResponseBody responseBody = response.body();
                if (null != responseBody) {
                    rsp.bytes = responseBody.bytes();
                }
                rsp.currentTimeMillis = System.currentTimeMillis();
                logger.info("------ > Call Service | Response Status: " + rsp.code);
                logger.info("------ > Call Service | Response Content: " + HttpClient.logBytes(rsp.bytes) + " Cost\uff1a" + (rsp.currentTimeMillis - req.currentTimeMillis));
                HttpClient.notifyRequest(req);
            }
            catch (IOException e) {
                rsp.currentTimeMillis = System.currentTimeMillis();
                rsp.message = e.getMessage();
                logger.info("------ > Call Service | Failure Content: " + rsp.message + " Cost\uff1a" + (rsp.currentTimeMillis - req.currentTimeMillis));
                HttpClient.notifyRequest(req);
            }
        }
        return rsp;
    }

    static String logBytes(byte[] bytes) {
        if (null == bytes) {
            return "";
        }
        int length = bytes.length;
        if (length > 20480) {
            byte[] bts = new byte[20480];
            System.arraycopy(bytes, 0, bts, 0, 20480);
            return new String(bts).concat("...");
        }
        return new String(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyRequest(Request req) {
        if (req.isAsync) {
            Request request = req;
            synchronized (request) {
                req.isExecuted = true;
                req.notify();
            }
        }
    }

    static {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 50, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new PaaSHttpThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        Dispatcher dispatcher = new Dispatcher((ExecutorService)executorService);
        okBuilder = new OkHttpClient.Builder();
        okBuilder.dispatcher(dispatcher);
        logger = Logger.getLogger("HTTP CLIENT UTILITIES");
    }

    public static class Response<T> {
        int code;
        String message;
        T t;
        byte[] bytes;
        final Request request;
        Class<T> rspType;
        private long currentTimeMillis = System.currentTimeMillis();
        private boolean isExecuted = false;

        Response(Request request, Class<T> rspType) {
            this.request = request;
            this.rspType = rspType;
        }

        public Response<T> execute() {
            String reqContent = HttpClient.logBytes(this.request.bytes);
            logger.info("------ > Call Service | Request Url: " + this.request.url);
            logger.info("------ > Call Service | Request Method: " + this.request.method.name());
            logger.info("------ > Call Service | Request Content: " + reqContent);
            this.isExecuted = true;
            HttpClient.request(this.request, this);
            return this;
        }

        public int getStatus() {
            this.waitResponse();
            return this.code;
        }

        public T getBody() {
            this.waitResponse();
            if (null != this.t) {
                return this.t;
            }
            int length = this.bytes.length;
            if (length >= 2 && (this.bytes[0] == 123 && this.bytes[length - 1] == 125 || this.bytes[0] == 91 && this.bytes[length - 1] == 93)) {
                this.t = JSON.parseObject((byte[])this.bytes, this.rspType, (Feature[])new Feature[0]);
            }
            return this.t;
        }

        public <TR> T getBody(TypeReference<TR> typeReference) {
            this.waitResponse();
            if (null != this.t) {
                return this.t;
            }
            int length = this.bytes.length;
            if (length >= 2 && (this.bytes[0] == 123 && this.bytes[length - 1] == 125 || this.bytes[0] == 91 && this.bytes[length - 1] == 93)) {
                this.t = JSON.parseObject((String)new String(this.bytes), typeReference, (Feature[])new Feature[0]);
            }
            return this.t;
        }

        public byte[] getBodyBytes() {
            this.waitResponse();
            return this.bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitResponse() {
            if (this.request.isAsync && this.isExecuted && !this.request.isExecuted) {
                Request request = this.request;
                synchronized (request) {
                    while (!this.request.isExecuted) {
                        try {
                            this.request.wait();
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
            }
        }
    }

    public static class Request<R> {
        String url;
        private Method method = Method.GET;
        private ContentType contentType;
        private R reqBody;
        private final Class<R> reqType;
        private byte[] bytes;
        private long readTimeout = 5000L;
        private long writeTimeout = 5000L;
        private long connectTimeout = 5000L;
        private final long currentTimeMillis = System.currentTimeMillis();
        private boolean isExecuted = false;
        private final Map<String, String> headers = new HashMap<String, String>();
        private boolean isAsync;
        private OkHttpClient okHttpClient;

        Request(Class<R> reqType, boolean isAsync) {
            this.reqType = reqType;
            this.isAsync = isAsync;
        }

        public Request<R> url(String url) {
            this.url = url;
            return this;
        }

        public Request<R> contentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public Request<R> method(Method method) {
            this.method = method;
            return this;
        }

        public Request<R> readTimeout(long milliseconds) {
            this.readTimeout = milliseconds;
            return this;
        }

        public Request<R> writeTimeout(long milliseconds) {
            this.writeTimeout = milliseconds;
            return this;
        }

        public Request<R> connectTimeout(long milliseconds) {
            this.connectTimeout = milliseconds;
            return this;
        }

        public Request<R> reqBody(R reqBody) {
            this.reqBody = reqBody;
            if (this.reqType == byte[].class) {
                this.bytes = (byte[])this.reqBody;
            }
            return this;
        }

        public Request<R> addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public <T> Response<T> ready(Class<T> rspType) {
            okBuilder.connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS);
            okBuilder.readTimeout(this.readTimeout, TimeUnit.MILLISECONDS);
            okBuilder.writeTimeout(this.writeTimeout, TimeUnit.MILLISECONDS);
            this.okHttpClient = okBuilder.build();
            if (null == this.reqBody) {
                this.bytes = new byte[0];
            } else if ((this.contentType == ContentType.APPLICATION_JSON || this.contentType == ContentType.APPLICATION_JSON_UTF8) && this.reqType != byte[].class) {
                this.bytes = JSON.toJSONBytes(this.reqBody, (SerializerFeature[])new SerializerFeature[0]);
            } else if (null == this.bytes) {
                this.bytes = new byte[0];
            }
            return new Response<T>(this, rspType);
        }
    }

    public static enum ContentType {
        APPLICATION_JSON("application/json"),
        APPLICATION_JSON_UTF8("application/json;charset=utf-8"),
        APPLICATION_FORM_URLENCODED("application/x-www-form-urlencoded"),
        APPLICATION_OCTET_STREAM("application/octet-stream"),
        APPLICATION_PDF("application/pdf"),
        APPLICATION_XML("application/xml"),
        MULTIPART_FORM_DATA("multipart/form-data");

        private final String name;

        private ContentType(String name) {
            this.name = name;
        }
    }

    public static enum Method {
        GET,
        HEAD,
        POST,
        PUT,
        PATCH,
        DELETE,
        OPTIONS,
        TRACE;

    }
}

