/*
 * Decompiled with CFR 0.152.
 */
package com.paas.utilities.json;

import com.alibaba.fastjson.JSON;

public class JsonUtil {
    public static void main(String[] args) {
        String s = ":";
        byte[] bytes = s.getBytes();
        JSON.toJSON((Object)s);
        boolean flag = JsonUtil.isJson(bytes);
    }

    public static boolean isJson(byte[] bytes) {
        int i;
        if (null == bytes || bytes.length < 2) {
            return false;
        }
        int length = bytes.length;
        int middle = length / 2;
        int start = -1;
        int end = -1;
        for (i = 0; i < middle; ++i) {
            if (bytes[i] == 32) continue;
            start = i;
            break;
        }
        for (i = length - 1; i >= middle; --i) {
            if (bytes[i] == 32) continue;
            end = i;
            break;
        }
        return start >= 0 && start < end && (bytes[start] == 123 && bytes[end] == 125 || bytes[start] == 91 && bytes[end] == 93);
    }

    public static boolean isJson(String json) {
        if (null == json) {
            return false;
        }
        return JsonUtil.isJson(json.getBytes());
    }

    public static String formatJson(String json) {
        if (!JsonUtil.isJson(json)) {
            return json;
        }
        StringBuilder result = new StringBuilder();
        char[] chars = json.toCharArray();
        int level = 0;
        block5: for (char c : chars) {
            switch (c) {
                case '[': 
                case '{': {
                    result.append(c).append("\n");
                    JsonUtil.appendTab(result, ++level);
                    continue block5;
                }
                case ']': 
                case '}': {
                    result.append("\n");
                    JsonUtil.appendTab(result, --level);
                    result.append(c);
                    continue block5;
                }
                case ',': {
                    result.append(c).append("\n");
                    JsonUtil.appendTab(result, level);
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    private static void appendTab(StringBuilder sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append("\t");
        }
    }
}

