/*
 * Decompiled with CFR 0.152.
 */
package com.paas.utilities.webservices;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;

public class SoapClient {
    private static final Logger logger = Logger.getLogger("SOAP CLIENT UTILITIES");
    private static final JaxWsDynamicClientFactory wsDynamicClientFactory = JaxWsDynamicClientFactory.newInstance();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[] doRequest(String wsdlAddress, String serviceName, Object ... args) {
        try (Client client = wsDynamicClientFactory.createClient(wsdlAddress);){
            Object[] objectArray = client.invoke(serviceName, args);
            return objectArray;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, ex.getMessage(), ex);
            return null;
        }
    }
}

