/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.log.util;

import com.github.zuihou.log.annotation.SysLog;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private static final Logger log = LoggerFactory.getLogger(LogUtil.class);

    public static String getDescribe(JoinPoint point) {
        SysLog annotation = LogUtil.getTargetAnno(point);
        if (annotation == null) {
            return "";
        }
        return annotation.value();
    }

    public static String getDescribe(SysLog annotation) {
        if (annotation == null) {
            return "";
        }
        return annotation.value();
    }

    public static SysLog getTargetAnno(JoinPoint point) {
        try {
            Method method;
            SysLog annotation = null;
            if (point.getSignature() instanceof MethodSignature && (method = ((MethodSignature)point.getSignature()).getMethod()) != null) {
                annotation = method.getAnnotation(SysLog.class);
            }
            return annotation;
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6 {}.{} \u7684 @SysLog \u6ce8\u89e3\u5931\u8d25", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), e});
            return null;
        }
    }
}

