/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.security.aspect;

import cn.hutool.core.collection.CollUtil;
import com.github.zuihou.base.R;
import com.github.zuihou.security.feign.UserQuery;
import com.github.zuihou.security.feign.UserResolverService;
import com.github.zuihou.security.model.SysRole;
import com.github.zuihou.security.model.SysUser;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;

public class VerifyAuthFunction {
    private final UserResolverService userResolverService;

    public VerifyAuthFunction(UserResolverService userResolverService) {
        this.userResolverService = userResolverService;
    }

    public boolean permit() {
        return true;
    }

    public boolean denyAll() {
        return this.hasRole("PT_ADMIN");
    }

    public boolean hasRole(String role) {
        return this.hasAnyRole(role);
    }

    public boolean hasPermit(String permit) {
        return this.hasAnyPermit(permit);
    }

    public boolean hasAnyPermit(String ... permit) {
        Set<String> resources = this.getAllResources();
        return CollUtil.containsAny(resources, (Collection)CollUtil.newHashSet((Object[])permit));
    }

    public boolean hasAllPermit(String ... permit) {
        Set<String> resources = this.getAllResources();
        return CollUtil.containsAll(resources, (Collection)CollUtil.newHashSet((Object[])permit));
    }

    @NonNull
    private Set<String> getAllResources() {
        HashSet<String> resources = new HashSet<String>();
        R<SysUser> result = this.userResolverService.getById(UserQuery.buildResource());
        if (result.getIsSuccess().booleanValue() && result.getData() != null && ((SysUser)result.getData()).getResources() != null) {
            SysUser sysUser = (SysUser)result.getData();
            resources = new HashSet<String>(sysUser.getResources());
        }
        return resources;
    }

    public boolean hasAnyRole(String ... role) {
        Set<String> roles = this.getAllRoles();
        return CollUtil.containsAny(roles, (Collection)CollUtil.newHashSet((Object[])role));
    }

    public boolean hasAllRole(String ... role) {
        Set<String> roles = this.getAllRoles();
        return CollUtil.containsAll(roles, (Collection)CollUtil.newHashSet((Object[])role));
    }

    @NonNull
    private Set<String> getAllRoles() {
        Set<String> roles = new HashSet<String>();
        R<SysUser> result = this.userResolverService.getById(UserQuery.buildRoles());
        if (result.getIsSuccess().booleanValue() && result.getData() != null && ((SysUser)result.getData()).getRoles() != null) {
            SysUser sysUser = (SysUser)result.getData();
            roles = sysUser.getRoles().stream().map(SysRole::getCode).collect(Collectors.toSet());
        }
        return roles;
    }
}

