/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.security.config;

import com.github.zuihou.security.aspect.UriSecurityPreAuthAspect;
import com.github.zuihou.security.aspect.VerifyAuthFunction;
import com.github.zuihou.security.feign.UserResolverService;
import com.github.zuihou.security.properties.SecurityProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@Order
@EnableConfigurationProperties(value={SecurityProperties.class})
public class SecurityConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="zuihou.security", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public UriSecurityPreAuthAspect uriSecurityPreAuthAspect(VerifyAuthFunction verifyAuthFunction) {
        return new UriSecurityPreAuthAspect(verifyAuthFunction);
    }

    @Bean(value={"fun"})
    @ConditionalOnMissingBean(value={VerifyAuthFunction.class})
    public VerifyAuthFunction getVerifyAuthFunction(UserResolverService userResolverService) {
        return new VerifyAuthFunction(userResolverService);
    }
}

