/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.security.config;

import com.github.zuihou.base.R;
import com.github.zuihou.security.feign.UserQuery;
import com.github.zuihou.security.feign.UserResolverService;
import com.github.zuihou.security.model.SysUser;
import com.github.zuihou.utils.SpringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Configuration
@ConditionalOnProperty(prefix="zuihou.security", name={"type"}, havingValue="FEIGN", matchIfMissing=true)
@EnableFeignClients(basePackageClasses={UserResolveApi.class})
public class UserResolveFeignConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={UserResolverService.class})
    public UserResolverService getUserResolverService(UserResolveApi userResolveApi) {
        return new UserResolverServiceFeignImpl(userResolveApi);
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringUtils.class})
    public SpringUtils getSpringUtils(ApplicationContext applicationContext) {
        SpringUtils.setApplicationContext((ApplicationContext)applicationContext);
        return new SpringUtils();
    }

    @Component
    public class UserResolveApiFallback
    implements UserResolveApi {
        @Override
        public R<SysUser> getById(Long id, UserQuery userQuery) {
            return R.timeout();
        }
    }

    public class UserResolverServiceFeignImpl
    implements UserResolverService {
        final UserResolveApi userResolveApi;

        public UserResolverServiceFeignImpl(UserResolveApi userResolveApi) {
            this.userResolveApi = userResolveApi;
        }

        @Override
        public R<SysUser> getById(Long id, UserQuery userQuery) {
            return this.userResolveApi.getById(id, userQuery);
        }
    }

    @FeignClient(name="${zuihou.feign.oauth-server:zuihou-oauth-server}", path="/user", fallback=UserResolveApiFallback.class)
    public static interface UserResolveApi {
        @PostMapping(value={"/anno/id/{id}"})
        public R<SysUser> getById(@PathVariable(value="id") Long var1, @RequestBody UserQuery var2);
    }
}

