/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Nullable;

public class BlobInfo
implements Serializable {
    private static final long serialVersionUID = 4530115855912621409L;
    static final String DEFAULT_MD5_HASH = "";
    static final String DEFAULT_GS_OBJECT_NAME = null;
    protected final BlobKey blobKey;
    protected final String contentType;
    protected final Date creation;
    protected final String filename;
    protected final long size;
    protected String md5Hash;
    protected final String gsObjectName;

    public BlobInfo(BlobKey blobKey, String contentType, Date creation, String filename, long size, String md5Hash, String gsObjectName) {
        if (blobKey == null) {
            throw new NullPointerException("blobKey must not be null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType must not be null");
        }
        if (creation == null) {
            throw new NullPointerException("creation must not be null");
        }
        if (filename == null) {
            throw new NullPointerException("filename must not be null");
        }
        if (md5Hash == null) {
            throw new NullPointerException("md5Hash must not be null");
        }
        if (DEFAULT_MD5_HASH.equals(gsObjectName)) {
            throw new IllegalArgumentException("gsObjectName must not be an empty string");
        }
        this.blobKey = blobKey;
        this.contentType = contentType;
        this.creation = creation;
        this.filename = filename;
        this.size = size;
        this.md5Hash = md5Hash;
        this.gsObjectName = gsObjectName;
    }

    public BlobInfo(BlobKey blobKey, String contentType, Date creation, String filename, long size, String md5Hash) {
        this(blobKey, contentType, creation, filename, size, md5Hash, DEFAULT_GS_OBJECT_NAME);
    }

    public BlobInfo(BlobKey blobKey, String contentType, Date creation, String filename, long size) {
        this(blobKey, contentType, creation, filename, size, DEFAULT_MD5_HASH, DEFAULT_GS_OBJECT_NAME);
    }

    public BlobKey getBlobKey() {
        return this.blobKey;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Date getCreation() {
        return this.creation;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getSize() {
        return this.size;
    }

    public String getMd5Hash() {
        return this.md5Hash;
    }

    @Nullable
    public String getGsObjectName() {
        return this.gsObjectName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlobInfo) {
            BlobInfo bi = (BlobInfo)obj;
            return this.blobKey.equals(bi.blobKey) && this.contentType.equals(bi.contentType) && this.creation.equals(bi.creation) && this.filename.equals(bi.filename) && this.size == bi.size && this.md5Hash.equals(bi.md5Hash) && Objects.equal(this.gsObjectName, bi.gsObjectName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.blobKey, this.contentType, this.creation, this.filename, this.size, this.md5Hash, this.gsObjectName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<BlobInfo: ");
        builder.append(this.blobKey);
        builder.append(", contentType = ");
        builder.append(this.contentType);
        builder.append(", creation = ");
        builder.append(this.creation);
        builder.append(", filename = ");
        builder.append(this.filename);
        builder.append(", size = ");
        builder.append(this.size);
        builder.append(", md5Hash = ");
        builder.append(this.md5Hash);
        if (this.gsObjectName != null) {
            builder.append(", gsObjectName = ");
            builder.append(this.gsObjectName);
        }
        builder.append(">");
        return builder.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.md5Hash == null) {
            this.md5Hash = DEFAULT_MD5_HASH;
        }
    }
}

