/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.CompositeIndexManager;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.IndexTranslator;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitHelper;
import com.google.appengine.api.datastore.QueryTranslator;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.apphosting.api.AppEngineInternal;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

@AppEngineInternal
public final class AdminDatastoreService
implements AsyncDatastoreService {
    private final AsyncDatastoreService delegate;
    private final AppIdNamespace appIdNamespace;
    static AsyncDatastoreServiceFactory factory = new AsyncDatastoreServiceFactory(){

        @Override
        public AsyncDatastoreService getInstance(DatastoreServiceConfig config) {
            return DatastoreServiceFactory.getAsyncDatastoreService(config);
        }

        @Override
        public CompositeIndexManager getCompositeIndexManager() {
            return new CompositeIndexManager();
        }
    };

    private AdminDatastoreService(DatastoreServiceConfig config, String appId, String namespace) {
        this.appIdNamespace = new AppIdNamespace(appId, namespace);
        config = new DatastoreServiceConfig(config).appIdNamespace(this.appIdNamespace);
        this.delegate = factory.getInstance(config);
    }

    public static AdminDatastoreService getInstance(String appId) {
        return AdminDatastoreService.getInstance(DatastoreServiceConfig.Builder.withDefaults(), appId, "");
    }

    public static AdminDatastoreService getInstance(String appId, String namespace) {
        return AdminDatastoreService.getInstance(DatastoreServiceConfig.Builder.withDefaults(), appId, namespace);
    }

    public static AdminDatastoreService getInstance(DatastoreServiceConfig config, String appId) {
        return AdminDatastoreService.getInstance(config, appId, "");
    }

    public static AdminDatastoreService getInstance(DatastoreServiceConfig config, String appId, String namespace) {
        return new AdminDatastoreService(config, appId, namespace);
    }

    public String getAppId() {
        return this.appIdNamespace.getAppId();
    }

    public String getNamespace() {
        return this.appIdNamespace.getNamespace();
    }

    AsyncDatastoreService getDelegate() {
        return this.delegate;
    }

    public QueryBuilder newQueryBuilder() {
        return new QueryBuilder(this.appIdNamespace);
    }

    public QueryBuilder newQueryBuilder(String kind) {
        return new QueryBuilder(this.appIdNamespace).setKind(kind);
    }

    public KeyBuilder newKeyBuilder(String kind) {
        return new KeyBuilder(this.appIdNamespace, kind);
    }

    public EntityBuilder newEntityBuilder(String kind) {
        return new EntityBuilder(this.appIdNamespace, kind);
    }

    public Index compositeIndexForQuery(Query query) {
        Set<Index> resultIndexes = this.compositeIndexesForQuery(query);
        return Iterables.getFirst(resultIndexes, null);
    }

    public Set<Index> compositeIndexesForQuery(Query query) {
        List<DatastorePb.Query> pbQueries = AdminDatastoreService.convertQueryToPbs(query, FetchOptions.Builder.withDefaults());
        HashSet<Index> resultSet = new HashSet<Index>();
        for (DatastorePb.Query queryProto : pbQueries) {
            CompositeIndexManager.IndexComponentsOnlyQuery indexQuery = new CompositeIndexManager.IndexComponentsOnlyQuery(queryProto);
            OnestoreEntity.Index index = factory.getCompositeIndexManager().compositeIndexForQuery(indexQuery);
            if (index == null) continue;
            resultSet.add(IndexTranslator.convertFromPb(index));
        }
        return resultSet;
    }

    public Index minimumCompositeIndexForQuery(Query query, Collection<Index> indexes) {
        Set<Index> resultIndexes = this.minimumCompositeIndexesForQuery(query, indexes);
        return Iterables.getFirst(resultIndexes, null);
    }

    public Set<Index> minimumCompositeIndexesForQuery(Query query, Collection<Index> indexes) {
        List<DatastorePb.Query> pbQueries = AdminDatastoreService.convertQueryToPbs(query, FetchOptions.Builder.withDefaults());
        ArrayList<OnestoreEntity.Index> indexPbs = Lists.newArrayListWithCapacity(indexes.size());
        for (Index index : indexes) {
            indexPbs.add(IndexTranslator.convertToPb(index));
        }
        HashSet<Index> resultSet = new HashSet<Index>();
        for (DatastorePb.Query queryProto : pbQueries) {
            CompositeIndexManager.IndexComponentsOnlyQuery indexQuery = new CompositeIndexManager.IndexComponentsOnlyQuery(queryProto);
            OnestoreEntity.Index index = factory.getCompositeIndexManager().minimumCompositeIndexForQuery(indexQuery, indexPbs);
            if (index == null) continue;
            resultSet.add(IndexTranslator.convertFromPb(index));
        }
        return resultSet;
    }

    private static List<DatastorePb.Query> convertQueryToPbs(Query query, FetchOptions fetchOptions) {
        List<MultiQueryBuilder> queriesToRun = QuerySplitHelper.splitQuery(query);
        query.setFilter(null);
        query.getFilterPredicates().clear();
        ArrayList<DatastorePb.Query> resultQueries = new ArrayList<DatastorePb.Query>();
        for (MultiQueryBuilder multiQuery : queriesToRun) {
            for (List<List<Query.FilterPredicate>> parallelQueries : multiQuery) {
                for (List<Query.FilterPredicate> singleQuery : parallelQueries) {
                    Query newQuery = new Query(query);
                    newQuery.getFilterPredicates().addAll(singleQuery);
                    DatastorePb.Query queryProto = QueryTranslator.convertToPb(newQuery, fetchOptions);
                    resultQueries.add(queryProto);
                }
            }
        }
        return resultQueries;
    }

    @Override
    public PreparedQuery prepare(Query query) {
        this.validateQuery(query);
        return this.delegate.prepare(query);
    }

    @Override
    public PreparedQuery prepare(Transaction txn, Query query) {
        this.validateQuery(query);
        return this.delegate.prepare(txn, query);
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.delegate.getCurrentTransaction();
    }

    @Override
    public Transaction getCurrentTransaction(Transaction returnedIfNoTxn) {
        return this.delegate.getCurrentTransaction(returnedIfNoTxn);
    }

    @Override
    public Collection<Transaction> getActiveTransactions() {
        return this.delegate.getActiveTransactions();
    }

    @Override
    public Future<Transaction> beginTransaction() {
        return this.delegate.beginTransaction();
    }

    @Override
    public Future<Transaction> beginTransaction(TransactionOptions options) {
        return this.delegate.beginTransaction(options);
    }

    @Override
    public Future<Entity> get(Key key) {
        this.validateKey(key);
        return this.delegate.get(key);
    }

    @Override
    public Future<Entity> get(Transaction txn, Key key) {
        this.validateKey(key);
        return this.delegate.get(txn, key);
    }

    @Override
    public Future<Map<Key, Entity>> get(Iterable<Key> keys) {
        this.validateKeys(keys);
        return this.delegate.get(keys);
    }

    @Override
    public Future<Map<Key, Entity>> get(Transaction txn, Iterable<Key> keys) {
        this.validateKeys(keys);
        return this.delegate.get(txn, keys);
    }

    @Override
    public Future<Key> put(Entity entity) {
        this.validateEntity(entity);
        return this.delegate.put(entity);
    }

    @Override
    public Future<Key> put(Transaction txn, Entity entity) {
        this.validateEntity(entity);
        return this.delegate.put(txn, entity);
    }

    @Override
    public Future<List<Key>> put(Iterable<Entity> entities) {
        this.validateEntities(entities);
        return this.delegate.put(entities);
    }

    @Override
    public Future<List<Key>> put(Transaction txn, Iterable<Entity> entities) {
        this.validateEntities(entities);
        return this.delegate.put(txn, entities);
    }

    @Override
    public Future<Void> delete(Key ... keys) {
        this.validateKeys(Arrays.asList(keys));
        return this.delegate.delete(keys);
    }

    @Override
    public Future<Void> delete(Transaction txn, Key ... keys) {
        this.validateKeys(Arrays.asList(keys));
        return this.delegate.delete(txn, keys);
    }

    @Override
    public Future<Void> delete(Iterable<Key> keys) {
        this.validateKeys(keys);
        return this.delegate.delete(keys);
    }

    @Override
    public Future<Void> delete(Transaction txn, Iterable<Key> keys) {
        this.validateKeys(keys);
        return this.delegate.delete(txn, keys);
    }

    @Override
    public Future<KeyRange> allocateIds(String kind, long num) {
        return this.delegate.allocateIds(kind, num);
    }

    @Override
    public Future<KeyRange> allocateIds(Key parent, String kind, long num) {
        return this.delegate.allocateIds(parent, kind, num);
    }

    @Override
    public Future<DatastoreAttributes> getDatastoreAttributes() {
        return this.delegate.getDatastoreAttributes();
    }

    @Override
    public Future<Map<Index, Index.IndexState>> getIndexes() {
        return this.delegate.getIndexes();
    }

    private void validateQuery(Query query) {
        Preconditions.checkArgument(query.getAppIdNamespace().equals(this.appIdNamespace), "Query is associated with a different appId or namespace");
    }

    private void validateKey(Key key) {
        Preconditions.checkArgument(key.getAppIdNamespace().equals(this.appIdNamespace), "key %s is associated with a different appId or namespace", (Object)key);
    }

    private void validateKeys(Iterable<Key> keys) {
        for (Key key : keys) {
            this.validateKey(key);
        }
    }

    private void validateEntity(Entity entity) {
        Preconditions.checkArgument(entity.getAppIdNamespace().equals(this.appIdNamespace), "Entity %s is associated with a different appId or namespace", (Object)entity.getKey());
    }

    private void validateEntities(Iterable<Entity> entities) {
        for (Entity entity : entities) {
            this.validateEntity(entity);
        }
    }

    static interface AsyncDatastoreServiceFactory {
        public AsyncDatastoreService getInstance(DatastoreServiceConfig var1);

        public CompositeIndexManager getCompositeIndexManager();
    }

    public static final class EntityBuilder
    extends AbstractKeyBuilder<EntityBuilder> {
        private EntityBuilder(AppIdNamespace appIdNamespace, String kind) {
            super(appIdNamespace, kind);
        }

        public Entity build() {
            return new Entity(this.createKey());
        }
    }

    public static final class KeyBuilder
    extends AbstractKeyBuilder<KeyBuilder> {
        private KeyBuilder(AppIdNamespace appIdNamespace, String kind) {
            super(appIdNamespace, kind);
        }

        public Key build() {
            return this.createKey();
        }
    }

    private static abstract class AbstractKeyBuilder<T extends AbstractKeyBuilder<T>> {
        protected final AppIdNamespace appIdNamespace;
        protected String kind;
        protected String name;
        protected Long id;
        protected Key parent;

        protected AbstractKeyBuilder(AppIdNamespace appIdNamespace, String kind) {
            this.appIdNamespace = appIdNamespace;
            this.setKind(kind);
        }

        public String getKind() {
            return this.kind;
        }

        public T setKind(String kind) {
            Preconditions.checkNotNull(kind);
            this.kind = kind;
            return (T)this;
        }

        public String getName() {
            return this.name;
        }

        public T setName(String name) {
            this.name = name;
            return (T)this;
        }

        public Long getId() {
            return this.id;
        }

        protected long getIdAsPrimitiveLong() {
            return this.id == null ? 0L : this.id;
        }

        public T setId(Long id) {
            this.id = id;
            return (T)this;
        }

        public Key getParent() {
            return this.parent;
        }

        public T setParent(Key parent) {
            this.parent = parent;
            return (T)this;
        }

        protected Key createKey() {
            return new Key(this.kind, this.parent, this.getIdAsPrimitiveLong(), this.name, this.appIdNamespace);
        }
    }

    public static final class QueryBuilder {
        private final AppIdNamespace appIdNamespace;
        private String kind;

        private QueryBuilder(AppIdNamespace appIdNamespace) {
            this.appIdNamespace = appIdNamespace;
        }

        public QueryBuilder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Query build() {
            return new Query(this.kind, null, null, false, this.appIdNamespace, false);
        }
    }
}

