/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files;

import com.google.appengine.api.files.Crc32c;
import com.google.appengine.api.files.FileWriteChannel;
import com.google.appengine.api.files.KeyOrderingException;
import com.google.appengine.api.files.RecordConstants;
import com.google.appengine.api.files.RecordWriteChannel;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@Deprecated
final class RecordWriteChannelImpl
implements RecordWriteChannel {
    protected static final String LOWEST_SEQUENCE_KEY = "\u0000";
    private final Object lock = new Object();
    private final FileWriteChannel output;
    private ByteBuffer writeBuffer;
    private String nextSequenceKey;
    private String lastSequenceKey;

    public RecordWriteChannelImpl(FileWriteChannel output) {
        this.output = output;
        this.writeBuffer = ByteBuffer.allocate(32768);
        this.writeBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public int write(ByteBuffer data) throws IOException {
        return this.write(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return this.output.isOpen();
        }
    }

    private void verifySequenceKey(String sequenceKey) throws IOException, KeyOrderingException {
        if (sequenceKey != null) {
            if (this.lastSequenceKey == null) {
                ByteBuffer emptyData = ByteBuffer.wrap(new byte[0]);
                try {
                    this.output.write(emptyData, LOWEST_SEQUENCE_KEY);
                }
                catch (KeyOrderingException exception) {
                    this.lastSequenceKey = exception.getLastGoodSequenceKey();
                }
            }
            if (this.lastSequenceKey != null && sequenceKey.compareTo(this.lastSequenceKey) <= 0) {
                throw new KeyOrderingException(null, this.lastSequenceKey);
            }
            this.lastSequenceKey = sequenceKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer data, String sequenceKey) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifySequenceKey(sequenceKey);
            if (sequenceKey != null && sequenceKey.equals(LOWEST_SEQUENCE_KEY)) {
                sequenceKey = null;
            }
            int bytesWritten = 0;
            Record lastRecord = new Record();
            do {
                int bytesToBlockEnd = this.writeBuffer.remaining();
                Record currentRecord = RecordWriteChannelImpl.createRecord(data, bytesToBlockEnd, lastRecord);
                this.writePhysicalRecord(data, currentRecord);
                bytesWritten += currentRecord.getBytes() + 7;
                lastRecord = currentRecord;
                if (lastRecord.getType() == RecordConstants.RecordType.FULL || lastRecord.getType() == RecordConstants.RecordType.LAST) {
                    this.nextSequenceKey = sequenceKey;
                }
                if ((bytesToBlockEnd = this.writeBuffer.remaining()) < 7 && bytesToBlockEnd > 0) {
                    this.writeBlanks(bytesToBlockEnd);
                    bytesWritten += bytesToBlockEnd;
                    bytesToBlockEnd = 0;
                }
                if (bytesToBlockEnd != 0) continue;
                this.writeBuffer.flip();
                this.output.write(this.writeBuffer, this.nextSequenceKey);
                this.writeBuffer.clear();
                this.nextSequenceKey = null;
            } while (data.hasRemaining());
            return bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFinally() throws IllegalStateException, IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closeStream(false);
            this.output.closeFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closeStream(true);
            this.output.close();
        }
    }

    private static Record createRecord(ByteBuffer data, int bytesToBlockEnd, Record lastRecord) {
        int bytesToDataEnd = data.remaining();
        RecordConstants.RecordType type = RecordConstants.RecordType.UNKNOWN;
        int bytes = -1;
        if (lastRecord.getType() == RecordConstants.RecordType.NONE && bytesToDataEnd + 7 <= bytesToBlockEnd) {
            type = RecordConstants.RecordType.FULL;
            bytes = bytesToDataEnd;
        } else if (lastRecord.getType() == RecordConstants.RecordType.NONE) {
            type = RecordConstants.RecordType.FIRST;
            bytes = bytesToBlockEnd - 7;
        } else if (bytesToDataEnd <= bytesToBlockEnd) {
            type = RecordConstants.RecordType.LAST;
            bytes = bytesToDataEnd;
        } else {
            type = RecordConstants.RecordType.MIDDLE;
            bytes = bytesToBlockEnd - 7;
        }
        return new Record(type, bytes);
    }

    private void writePhysicalRecord(ByteBuffer data, Record record) {
        this.writeBuffer.putInt(this.generateCrc(data.array(), data.position(), record.getBytes(), record.getType()));
        this.writeBuffer.putShort((short)record.getBytes());
        this.writeBuffer.put(record.getType().value());
        this.writeBuffer.put(data.array(), data.position(), record.getBytes());
        data.position(data.position() + record.getBytes());
    }

    private void writeBlanks(int numBlanks) {
        for (int i = 0; i < numBlanks; ++i) {
            this.writeBuffer.put((byte)0);
        }
    }

    private int generateCrc(byte[] data, int off, int len, RecordConstants.RecordType type) {
        Crc32c crc = new Crc32c();
        crc.update(type.value());
        crc.update(data, off, len);
        return (int)RecordConstants.maskCrc(crc.getValue());
    }

    private void closeStream(boolean pad) throws IOException {
        int bytesToBlockEnd = this.writeBuffer.remaining();
        if (bytesToBlockEnd < 32768) {
            if (pad) {
                this.writeBlanks(bytesToBlockEnd);
            }
            this.writeBuffer.flip();
            this.output.write(this.writeBuffer, this.nextSequenceKey);
            this.nextSequenceKey = null;
            this.writeBuffer.clear();
        }
    }

    private static final class Record {
        private final RecordConstants.RecordType type;
        private final int bytes;

        private Record() {
            this.type = RecordConstants.RecordType.NONE;
            this.bytes = 0;
        }

        private Record(RecordConstants.RecordType type, int bytes) {
            Preconditions.checkArgument(type != RecordConstants.RecordType.UNKNOWN);
            Preconditions.checkArgument(bytes >= 0);
            this.type = type;
            this.bytes = bytes;
        }

        int getBytes() {
            return this.bytes;
        }

        RecordConstants.RecordType getType() {
            return this.type;
        }
    }
}

