/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.StatusCode;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.apphosting.api.ApiProxy;
import java.io.Serializable;

public class OperationResult
implements Serializable {
    private static final long serialVersionUID = 3608247775865189592L;
    private final StatusCode code;
    private final String message;

    OperationResult(SearchServicePb.RequestStatus status) {
        this(status.getCode(), status.hasErrorDetail() ? status.getErrorDetail() : null);
    }

    OperationResult(SearchServicePb.SearchServiceError.ErrorCode code, String errorDetail) {
        this(StatusCode.fromErrorCode(code), errorDetail);
    }

    public OperationResult(StatusCode code, String errorDetail) {
        this.code = code;
        this.message = errorDetail;
    }

    public StatusCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        if (this.message == null) {
            return this.code.name();
        }
        String string = this.code.name();
        String string2 = this.message;
        return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.getClass().isAssignableFrom(object.getClass())) {
            return false;
        }
        OperationResult result = (OperationResult)object;
        boolean sameMessages = this.message == null && result.message == null || this.message != null && this.message.equals(result.message);
        return this.code.equals((Object)result.code) && sameMessages;
    }

    static OperationResult convertToOperationResult(Throwable cause) {
        ApiProxy.ApplicationException exception;
        int applicationError;
        if (cause instanceof ApiProxy.ApplicationException && (applicationError = (exception = (ApiProxy.ApplicationException)cause).getApplicationError()) != 0) {
            SearchServicePb.SearchServiceError.ErrorCode code = SearchServicePb.SearchServiceError.ErrorCode.forNumber(applicationError);
            if (code == null) {
                return new OperationResult(StatusCode.INTERNAL_ERROR, exception.getErrorDetail());
            }
            return new OperationResult(StatusCode.fromErrorCode(code), exception.getErrorDetail());
        }
        return null;
    }
}

