/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags.ext;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagValueException;
import com.google.appengine.repackaged.org.joda.time.Period;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.format.PeriodFormatter;
import com.google.appengine.repackaged.org.joda.time.format.PeriodFormatterBuilder;
import javax.annotation.Nullable;

public class JodaPeriodFlag
extends Flag<Period> {
    private static final PeriodFormatter DEFAULT_FORMATTER = new PeriodFormatterBuilder().appendYears().appendSuffix("y").appendMonths().appendSuffix("mm").appendWeeks().appendSuffix("w").appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSecondsWithOptionalMillis().appendSuffix("s").toFormatter();
    private final PeriodFormatter formatter;

    private JodaPeriodFlag(PeriodFormatter formatter, Period defaultValue) {
        super(defaultValue);
        this.formatter = Preconditions.checkNotNull(formatter);
    }

    public static Flag<Period> value(PeriodFormatter formatter, @Nullable ReadablePeriod defaultValue) {
        return new JodaPeriodFlag(formatter, defaultValue == null ? null : defaultValue.toPeriod());
    }

    public static Flag<Period> value(@Nullable ReadablePeriod defaultValue) {
        return new JodaPeriodFlag(DEFAULT_FORMATTER, defaultValue == null ? null : defaultValue.toPeriod());
    }

    public static Flag<Period> nullValue(PeriodFormatter formatter) {
        return new JodaPeriodFlag(formatter, null);
    }

    public static Flag<Period> nullValue() {
        return new JodaPeriodFlag(DEFAULT_FORMATTER, null);
    }

    @Override
    protected Period parse(String text) throws InvalidFlagValueException {
        try {
            return this.formatter.parsePeriod(text);
        }
        catch (IllegalArgumentException e) {
            InvalidFlagValueException invalidFlagValueException = new InvalidFlagValueException(e.getMessage());
            invalidFlagValueException.initCause(e);
            throw invalidFlagValueException;
        }
    }

    @Override
    protected String parsableStringValue(Period value) {
        return this.formatter.print(value);
    }

    public static final class PeriodFactory {
        @Nullable
        public static Period valueOf(String text) {
            return text.isEmpty() ? null : DEFAULT_FORMATTER.parsePeriod(text);
        }

        private PeriodFactory() {
        }
    }
}

