/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1.client;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.appengine.repackaged.com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.datastore.v1.ArrayValue;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.Entity;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReference;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import com.google.appengine.repackaged.com.google.datastore.v1.client.Datastore;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreFactory;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.client.QuerySplitter;
import com.google.appengine.repackaged.com.google.datastore.v1.client.QuerySplitterImpl;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.appengine.repackaged.com.google.protobuf.TimestampOrBuilder;
import com.google.appengine.repackaged.com.google.type.LatLng;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DatastoreHelper {
    private static final Logger logger = Logger.getLogger(DatastoreHelper.class.getName());
    private static final int MICROSECONDS_PER_SECOND = 1000000;
    private static final int NANOSECONDS_PER_MICROSECOND = 1000;
    public static final String SCATTER_PROPERTY_NAME = "__scatter__";
    public static final String KEY_PROPERTY_NAME = "__key__";
    public static final String PROJECT_ID_ENV_VAR = "DATASTORE_PROJECT_ID";
    public static final String LOCAL_HOST_ENV_VAR = "DATASTORE_EMULATOR_HOST";
    public static final String SERVICE_ACCOUNT_ENV_VAR = "DATASTORE_SERVICE_ACCOUNT";
    public static final String PRIVATE_KEY_FILE_ENV_VAR = "DATASTORE_PRIVATE_KEY_FILE";
    private static final String URL_OVERRIDE_ENV_VAR = "__DATASTORE_URL_OVERRIDE";

    private DatastoreHelper() {
    }

    private static HttpTransport newTransport() throws GeneralSecurityException, IOException {
        return GoogleNetHttpTransport.newTrustedTransport();
    }

    static JsonFactory newJsonFactory() {
        return new JacksonFactory();
    }

    public static Credential getServiceAccountCredential(String serviceAccountId, String privateKeyFile) throws GeneralSecurityException, IOException {
        return DatastoreHelper.getServiceAccountCredential(serviceAccountId, privateKeyFile, DatastoreOptions.SCOPES);
    }

    public static Credential getServiceAccountCredential(String serviceAccountId, String privateKeyFile, Collection<String> serviceAccountScopes) throws GeneralSecurityException, IOException {
        return DatastoreHelper.getCredentialBuilderWithoutPrivateKey(serviceAccountId, serviceAccountScopes).setServiceAccountPrivateKeyFromP12File(new File(privateKeyFile)).build();
    }

    public static Credential getServiceAccountCredential(String serviceAccountId, PrivateKey privateKey, Collection<String> serviceAccountScopes) throws GeneralSecurityException, IOException {
        return DatastoreHelper.getCredentialBuilderWithoutPrivateKey(serviceAccountId, serviceAccountScopes).setServiceAccountPrivateKey(privateKey).build();
    }

    private static GoogleCredential.Builder getCredentialBuilderWithoutPrivateKey(String serviceAccountId, Collection<String> serviceAccountScopes) throws GeneralSecurityException, IOException {
        HttpTransport transport = DatastoreHelper.newTransport();
        JsonFactory jsonFactory = DatastoreHelper.newJsonFactory();
        return new GoogleCredential.Builder().setTransport(transport).setJsonFactory(jsonFactory).setServiceAccountId(serviceAccountId).setServiceAccountScopes(serviceAccountScopes);
    }

    public static DatastoreOptions.Builder getOptionsFromEnv() throws GeneralSecurityException, IOException {
        DatastoreOptions.Builder options = new DatastoreOptions.Builder();
        DatastoreHelper.setProjectEndpointFromEnv(options);
        options.credential(DatastoreHelper.getCredentialFromEnv());
        return options;
    }

    private static Credential getCredentialFromEnv() throws GeneralSecurityException, IOException {
        if (System.getenv(LOCAL_HOST_ENV_VAR) != null) {
            logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreHelper", "getCredentialFromEnv", "{0} environment variable was set. Not using credentials.", new Object[]{LOCAL_HOST_ENV_VAR});
            return null;
        }
        String serviceAccount = System.getenv(SERVICE_ACCOUNT_ENV_VAR);
        String privateKeyFile = System.getenv(PRIVATE_KEY_FILE_ENV_VAR);
        if (serviceAccount != null && privateKeyFile != null) {
            logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreHelper", "getCredentialFromEnv", "{0} and {1} environment variables were set. Using service account credential.", new Object[]{SERVICE_ACCOUNT_ENV_VAR, PRIVATE_KEY_FILE_ENV_VAR});
            return DatastoreHelper.getServiceAccountCredential(serviceAccount, privateKeyFile);
        }
        return GoogleCredential.getApplicationDefault().createScoped(DatastoreOptions.SCOPES);
    }

    private static String getProjectIdFromEnv() {
        if (System.getenv(PROJECT_ID_ENV_VAR) != null) {
            return System.getenv(PROJECT_ID_ENV_VAR);
        }
        String projectIdFromComputeEngine = DatastoreHelper.getProjectIdFromComputeEngine();
        if (projectIdFromComputeEngine != null) {
            return projectIdFromComputeEngine;
        }
        throw new IllegalStateException(String.format("Could not determine project ID. If you are not running on Compute Engine, set the %s environment variable.", PROJECT_ID_ENV_VAR));
    }

    public static String getProjectIdFromComputeEngine() {
        HttpTransport transport;
        try {
            transport = DatastoreHelper.newTransport();
        }
        catch (IOException | GeneralSecurityException e) {
            logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreHelper", "getProjectIdFromComputeEngine", "Failed to create HttpTransport.", e);
            return null;
        }
        try {
            GenericUrl projectIdUrl = new GenericUrl("http://metadata/computeMetadata/v1/project/project-id");
            HttpRequest request = transport.createRequestFactory().buildGetRequest(projectIdUrl);
            request.getHeaders().set("Metadata-Flavor", "Google");
            return request.execute().parseAsString();
        }
        catch (IOException e) {
            logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreHelper", "getProjectIdFromComputeEngine", "Could not determine project ID from Compute Engine.", e);
            return null;
        }
    }

    private static void setProjectEndpointFromEnv(DatastoreOptions.Builder options) {
        if (System.getenv("DATASTORE_HOST") != null) {
            logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreHelper", "setProjectEndpointFromEnv", String.format("Ignoring value of environment variable DATASTORE_HOST. To point datastore to a host running locally, use the environment variable %s.", LOCAL_HOST_ENV_VAR));
        }
        String projectId = DatastoreHelper.getProjectIdFromEnv();
        if (System.getenv(URL_OVERRIDE_ENV_VAR) != null) {
            options.projectEndpoint(String.format("%s/projects/%s", System.getenv(URL_OVERRIDE_ENV_VAR), projectId));
            return;
        }
        if (System.getenv(LOCAL_HOST_ENV_VAR) != null) {
            options.projectId(projectId);
            options.localHost(System.getenv(LOCAL_HOST_ENV_VAR));
            return;
        }
        options.projectId(projectId);
    }

    public static Datastore getDatastoreFromEnv() throws GeneralSecurityException, IOException {
        return DatastoreFactory.get().create(DatastoreHelper.getOptionsFromEnv().build());
    }

    public static QuerySplitter getQuerySplitter() {
        return QuerySplitterImpl.INSTANCE;
    }

    public static Comparator<Key> getKeyComparator() {
        return KeyComparator.INSTANCE;
    }

    public static PropertyOrder.Builder makeOrder(String property, PropertyOrder.Direction direction) {
        return PropertyOrder.newBuilder().setProperty(DatastoreHelper.makePropertyReference(property)).setDirection(direction);
    }

    public static Filter.Builder makeAncestorFilter(Key ancestor) {
        return DatastoreHelper.makeFilter(KEY_PROPERTY_NAME, PropertyFilter.Operator.HAS_ANCESTOR, DatastoreHelper.makeValue(ancestor));
    }

    public static Filter.Builder makeFilter(String property, PropertyFilter.Operator operator, Value value) {
        return Filter.newBuilder().setPropertyFilter(PropertyFilter.newBuilder().setProperty(DatastoreHelper.makePropertyReference(property)).setOp(operator).setValue(value));
    }

    public static Filter.Builder makeFilter(String property, PropertyFilter.Operator operator, Value.Builder value) {
        return DatastoreHelper.makeFilter(property, operator, value.build());
    }

    public static Filter.Builder makeAndFilter(Filter ... subfilters) {
        return DatastoreHelper.makeAndFilter(Arrays.asList(subfilters));
    }

    public static Filter.Builder makeAndFilter(Iterable<Filter> subfilters) {
        return Filter.newBuilder().setCompositeFilter(CompositeFilter.newBuilder().addAllFilters(subfilters).setOp(CompositeFilter.Operator.AND));
    }

    public static PropertyReference.Builder makePropertyReference(String propertyName) {
        return PropertyReference.newBuilder().setName(propertyName);
    }

    public static Value.Builder makeValue(Iterable<Value> values) {
        return Value.newBuilder().setArrayValue(ArrayValue.newBuilder().addAllValues(values));
    }

    public static Value.Builder makeValue(Value value1, Value value2, Value ... rest) {
        ArrayValue.Builder arrayValue = ArrayValue.newBuilder();
        arrayValue.addValues(value1);
        arrayValue.addValues(value2);
        arrayValue.addAllValues(Arrays.asList(rest));
        return Value.newBuilder().setArrayValue(arrayValue);
    }

    public static Value.Builder makeValue(Value.Builder value1, Value.Builder value2, Value.Builder ... rest) {
        ArrayValue.Builder arrayValue = ArrayValue.newBuilder();
        arrayValue.addValues(value1);
        arrayValue.addValues(value2);
        for (Value.Builder builder : rest) {
            arrayValue.addValues(builder);
        }
        return Value.newBuilder().setArrayValue(arrayValue);
    }

    public static Value.Builder makeValue(Key key) {
        return Value.newBuilder().setKeyValue(key);
    }

    public static Value.Builder makeValue(Key.Builder key) {
        return DatastoreHelper.makeValue(key.build());
    }

    public static Value.Builder makeValue(long key) {
        return Value.newBuilder().setIntegerValue(key);
    }

    public static Value.Builder makeValue(double value) {
        return Value.newBuilder().setDoubleValue(value);
    }

    public static Value.Builder makeValue(boolean value) {
        return Value.newBuilder().setBooleanValue(value);
    }

    public static Value.Builder makeValue(String value) {
        return Value.newBuilder().setStringValue(value);
    }

    public static Value.Builder makeValue(Entity entity) {
        return Value.newBuilder().setEntityValue(entity);
    }

    public static Value.Builder makeValue(Entity.Builder entity) {
        return DatastoreHelper.makeValue(entity.build());
    }

    public static Value.Builder makeValue(ByteString blob) {
        return Value.newBuilder().setBlobValue(blob);
    }

    public static Value.Builder makeValue(Date date) {
        return Value.newBuilder().setTimestampValue(DatastoreHelper.toTimestamp(date.getTime() * 1000L));
    }

    private static Timestamp.Builder toTimestamp(long microseconds) {
        long seconds = microseconds / 1000000L;
        long microsecondsRemainder = microseconds % 1000000L;
        if (microsecondsRemainder < 0L) {
            microsecondsRemainder += 1000000L;
            --seconds;
        }
        return Timestamp.newBuilder().setSeconds(seconds).setNanos((int)microsecondsRemainder * 1000);
    }

    public static Value.Builder makeValue(LatLng value) {
        return Value.newBuilder().setGeoPointValue(value);
    }

    public static Value.Builder makeValue(LatLng.Builder value) {
        return DatastoreHelper.makeValue(value.build());
    }

    public static Key.Builder makeKey(Object ... elements) {
        Key.Builder key = Key.newBuilder();
        PartitionId partitionId = null;
        for (int pathIndex = 0; pathIndex < elements.length; pathIndex += 2) {
            String kind;
            Key.PathElement.Builder pathElement = Key.PathElement.newBuilder();
            Object element = elements[pathIndex];
            if (element instanceof Key) {
                Key subKey = (Key)element;
                if (partitionId == null) {
                    partitionId = subKey.getPartitionId();
                } else if (!partitionId.equals(subKey.getPartitionId())) {
                    String string = String.valueOf(partitionId);
                    String string2 = String.valueOf(subKey.getPartitionId());
                    throw new IllegalArgumentException(new StringBuilder(41 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Partition IDs did not match, found: ").append(string).append(" and ").append(string2).toString());
                }
                key.addAllPath(((Key)element).getPathList());
                --pathIndex;
                continue;
            }
            try {
                kind = (String)element;
            }
            catch (ClassCastException e) {
                String string = String.valueOf(element.getClass());
                throw new IllegalArgumentException(new StringBuilder(29 + String.valueOf(string).length()).append("Expected string or Key, got: ").append(string).toString());
            }
            pathElement.setKind(kind);
            if (pathIndex + 1 < elements.length) {
                Object value = elements[pathIndex + 1];
                if (value instanceof String) {
                    pathElement.setName((String)value);
                } else if (value instanceof Long) {
                    pathElement.setId((Long)value);
                } else if (value instanceof Integer) {
                    pathElement.setId(((Integer)value).intValue());
                } else if (value instanceof Short) {
                    pathElement.setId(((Short)value).shortValue());
                } else {
                    String string = String.valueOf(value.getClass());
                    throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length()).append("Expected string or integer, got: ").append(string).toString());
                }
            }
            key.addPath(pathElement);
        }
        if (partitionId != null && !partitionId.equals(PartitionId.getDefaultInstance())) {
            key.setPartitionId(partitionId);
        }
        return key;
    }

    public static double getDouble(Value value) {
        if (value.getValueTypeCase() != Value.ValueTypeCase.DOUBLE_VALUE) {
            throw new IllegalArgumentException("Value does not contain a double.");
        }
        return value.getDoubleValue();
    }

    public static Key getKey(Value value) {
        if (value.getValueTypeCase() != Value.ValueTypeCase.KEY_VALUE) {
            throw new IllegalArgumentException("Value does not contain a key.");
        }
        return value.getKeyValue();
    }

    public static ByteString getByteString(Value value) {
        if (value.getMeaning() == 18 && value.getValueTypeCase() == Value.ValueTypeCase.STRING_VALUE) {
            return value.getStringValueBytes();
        }
        if (value.getValueTypeCase() == Value.ValueTypeCase.BLOB_VALUE) {
            return value.getBlobValue();
        }
        throw new IllegalArgumentException("Value does not contain a blob.");
    }

    public static Entity getEntity(Value value) {
        if (value.getValueTypeCase() != Value.ValueTypeCase.ENTITY_VALUE) {
            throw new IllegalArgumentException("Value does not contain an Entity.");
        }
        return value.getEntityValue();
    }

    public static String getString(Value value) {
        if (value.getValueTypeCase() != Value.ValueTypeCase.STRING_VALUE) {
            throw new IllegalArgumentException("Value does not contain a string.");
        }
        return value.getStringValue();
    }

    public static boolean getBoolean(Value value) {
        if (value.getValueTypeCase() != Value.ValueTypeCase.BOOLEAN_VALUE) {
            throw new IllegalArgumentException("Value does not contain a boolean.");
        }
        return value.getBooleanValue();
    }

    public static long getLong(Value value) {
        if (value.getValueTypeCase() != Value.ValueTypeCase.INTEGER_VALUE) {
            throw new IllegalArgumentException("Value does not contain an integer.");
        }
        return value.getIntegerValue();
    }

    public static long getTimestamp(Value value) {
        if (value.getMeaning() == 18 && value.getValueTypeCase() == Value.ValueTypeCase.INTEGER_VALUE) {
            return value.getIntegerValue();
        }
        if (value.getValueTypeCase() == Value.ValueTypeCase.TIMESTAMP_VALUE) {
            return DatastoreHelper.toMicroseconds(value.getTimestampValue());
        }
        throw new IllegalArgumentException("Value does not contain a timestamp.");
    }

    private static long toMicroseconds(TimestampOrBuilder timestamp) {
        return timestamp.getSeconds() * 1000000L + (long)(timestamp.getNanos() / 1000);
    }

    public static List<Value> getList(Value value) {
        if (value.getValueTypeCase() != Value.ValueTypeCase.ARRAY_VALUE) {
            throw new IllegalArgumentException("Value does not contain an array.");
        }
        return value.getArrayValue().getValuesList();
    }

    public static Date toDate(Value value) {
        return new Date(DatastoreHelper.getTimestamp(value) / 1000L);
    }

    public static Mutation.Builder makeInsert(Entity entity) {
        return Mutation.newBuilder().setInsert(entity);
    }

    public static Mutation.Builder makeUpdate(Entity entity) {
        return Mutation.newBuilder().setUpdate(entity);
    }

    public static Mutation.Builder makeUpsert(Entity entity) {
        return Mutation.newBuilder().setUpsert(entity);
    }

    public static Mutation.Builder makeDelete(Key key) {
        return Mutation.newBuilder().setDelete(key);
    }

    private static final class KeyComparator
    implements Comparator<Key> {
        static final KeyComparator INSTANCE = new KeyComparator();

        private KeyComparator() {
        }

        private int comparePathElement(Key.PathElement thisElement, Key.PathElement otherElement) {
            int result = thisElement.getKind().compareTo(otherElement.getKind());
            if (result != 0) {
                return result;
            }
            if (thisElement.getIdTypeCase() == Key.PathElement.IdTypeCase.ID) {
                if (otherElement.getIdTypeCase() != Key.PathElement.IdTypeCase.ID) {
                    return -1;
                }
                return Long.valueOf(thisElement.getId()).compareTo(otherElement.getId());
            }
            if (otherElement.getIdTypeCase() == Key.PathElement.IdTypeCase.ID) {
                return 1;
            }
            return thisElement.getName().compareTo(otherElement.getName());
        }

        @Override
        public int compare(Key thisKey, Key otherKey) {
            if (!thisKey.getPartitionId().equals(otherKey.getPartitionId())) {
                throw new IllegalArgumentException("Cannot compare keys with different partition ids.");
            }
            Iterator<Key.PathElement> thisPath = thisKey.getPathList().iterator();
            Iterator<Key.PathElement> otherPath = otherKey.getPathList().iterator();
            while (thisPath.hasNext()) {
                if (!otherPath.hasNext()) {
                    return 1;
                }
                int result = this.comparePathElement(thisPath.next(), otherPath.next());
                if (result == 0) continue;
                return result;
            }
            return otherPath.hasNext() ? -1 : 0;
        }
    }
}

