/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Instant;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormat;

public class IllegalInstantException
extends IllegalArgumentException {
    private static final long serialVersionUID = 2858712538216L;

    public IllegalInstantException(String message) {
        super(message);
    }

    public IllegalInstantException(long instantLocal, String zoneId) {
        super(IllegalInstantException.createMessage(instantLocal, zoneId));
    }

    private static String createMessage(long instantLocal, String zoneId) {
        String localDateTime = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").print(new Instant(instantLocal));
        String zone = zoneId != null ? new StringBuilder(3 + String.valueOf(zoneId).length()).append(" (").append(zoneId).append(")").toString() : "";
        return new StringBuilder(82 + String.valueOf(localDateTime).length() + String.valueOf(zone).length()).append("Illegal instant due to time zone offset transition (daylight savings time 'gap'): ").append(localDateTime).append(zone).toString();
    }

    public static boolean isIllegalInstant(Throwable ex) {
        if (ex instanceof IllegalInstantException) {
            return true;
        }
        if (ex.getCause() != null && ex.getCause() != ex) {
            return IllegalInstantException.isIllegalInstant(ex.getCause());
        }
        return false;
    }
}

