/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.convert;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.chrono.BuddhistChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.GJChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.GregorianChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.JulianChronology;
import com.google.appengine.repackaged.org.joda.time.convert.AbstractConverter;
import com.google.appengine.repackaged.org.joda.time.convert.InstantConverter;
import com.google.appengine.repackaged.org.joda.time.convert.PartialConverter;
import java.util.Calendar;
import java.util.GregorianCalendar;

final class CalendarConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final CalendarConverter INSTANCE = new CalendarConverter();

    protected CalendarConverter() {
    }

    @Override
    public Chronology getChronology(Object object, Chronology chrono) {
        if (chrono != null) {
            return chrono;
        }
        Calendar cal = (Calendar)object;
        DateTimeZone zone = null;
        try {
            zone = DateTimeZone.forTimeZone(cal.getTimeZone());
        }
        catch (IllegalArgumentException ex) {
            zone = DateTimeZone.getDefault();
        }
        return this.getChronology((Object)cal, zone);
    }

    @Override
    public Chronology getChronology(Object object, DateTimeZone zone) {
        if (object.getClass().getName().endsWith(".BuddhistCalendar")) {
            return BuddhistChronology.getInstance(zone);
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gc = (GregorianCalendar)object;
            long cutover = gc.getGregorianChange().getTime();
            if (cutover == Long.MIN_VALUE) {
                return GregorianChronology.getInstance(zone);
            }
            if (cutover == Long.MAX_VALUE) {
                return JulianChronology.getInstance(zone);
            }
            return GJChronology.getInstance(zone, cutover, 4);
        }
        return ISOChronology.getInstance(zone);
    }

    @Override
    public long getInstantMillis(Object object, Chronology chrono) {
        Calendar calendar = (Calendar)object;
        return calendar.getTime().getTime();
    }

    @Override
    public Class<?> getSupportedType() {
        return Calendar.class;
    }
}

